/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.JGR.util.TableSorter;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.ibase.toolkit.TJFrame;

public class JGRPackageManager
extends TJFrame
implements ActionListener {
    private static final long serialVersionUID = -7143083791080919475L;
    private Object[][] Packages = null;
    private final String[] columnNames = new String[]{"loaded", "default", "Package", "Description"};
    public static Object[] defaultPackages;
    public static HashMap neededPackages;
    private Object[][] MPackages = null;
    public static String remindPackages;
    private final JScrollPane scrollArea = new JScrollPane();
    private final JButton close = new JButton("Close");
    private final JButton refresh = new JButton("Refresh");
    private final JButton dontremind = new JButton("Don't remind me again");
    private final JButton instlater = new JButton("Install later");
    private final JButton instnow = new JButton("Install now");
    private TableSorter sorter;
    private PTableModel pkgModel;
    private final JTable pkgTable = new JTable();
    private static JGRPackageManager instance;

    public JGRPackageManager(Vector vector) {
        super("Deleted Packages after last session:", false, 154);
        String string = "";
        for (int i = 0; i < vector.size() - 1; ++i) {
            string = string + vector.elementAt(i) + ",";
        }
        remindPackages = string = vector.elementAt(vector.size() - 1) + "";
        StringTokenizer stringTokenizer = new StringTokenizer(remindPackages, ",");
        this.MPackages = new Object[stringTokenizer.countTokens()][2];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.MPackages[n][1] = stringTokenizer.nextToken();
            this.MPackages[n][0] = new Boolean(true);
            ++n;
        }
        this.dontremind.setActionCommand("dontremind");
        this.dontremind.addActionListener(this);
        this.instlater.setActionCommand("instlater");
        this.instlater.addActionListener(this);
        this.instnow.setActionCommand("instnow");
        this.instnow.addActionListener(this);
        this.sorter = new TableSorter(new PMTableModel(this));
        this.scrollArea.setBackground(this.getBackground());
        this.pkgTable.setBackground(this.getBackground());
        this.pkgTable.setColumnModel(new PMTableColumnModel());
        this.pkgTable.setModel(this.sorter);
        this.pkgTable.setShowGrid(false);
        this.pkgTable.setCellSelectionEnabled(false);
        this.pkgTable.setColumnSelectionAllowed(false);
        this.pkgTable.setRowSelectionAllowed(false);
        this.pkgTable.setFocusable(false);
        this.pkgTable.getTableHeader().setReorderingAllowed(false);
        this.sorter.setTableHeader(this.pkgTable.getTableHeader());
        this.scrollArea.getViewport().setBackground(this.getBackground());
        this.scrollArea.getViewport().add(this.pkgTable);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(this.dontremind);
        JLabel jLabel = new JLabel();
        jLabel.setMinimumSize(new Dimension(10, 25));
        jLabel.setPreferredSize(new Dimension(10, 25));
        jLabel.setMaximumSize(new Dimension(10, 25));
        jPanel.add(jLabel);
        jPanel.add(this.instlater);
        jPanel.add(this.instnow);
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(new JLabel("Last time you had the following packages installed!"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        this.getContentPane().add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.scrollArea, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(this.instnow);
        this.setLocation((JGR.MAINRCONSOLE.getSize().width - (JGRPrefs.isMac ? 450 : 350)) / 2, (JGR.MAINRCONSOLE.getSize().height - 250) / 2);
        this.setSize(450, 250);
        this.setVisible(true);
    }

    private JGRPackageManager() {
        super("Package Manager", false, 154);
        try {
            String[] stringArray = new String[]{"~Window", "0"};
            EzMenuSwing.getEzMenu((JFrame)((Object)this), (ActionListener)this, (String[])stringArray);
            this.close.setActionCommand("exit");
            this.close.addActionListener(this);
            this.refresh.setActionCommand("refresh");
            this.refresh.addActionListener(this);
            while (!JGR.STARTED) {
            }
            this.Packages = RController.refreshPackages();
            this.pkgModel = new PTableModel(this);
            this.sorter = new TableSorter(this.pkgModel);
            this.scrollArea.setBackground(this.getBackground());
            this.pkgTable.setBackground(this.getBackground());
            this.pkgTable.setColumnModel(new PTableColumnModel());
            this.pkgTable.setModel(this.sorter);
            this.pkgTable.setShowGrid(false);
            this.pkgTable.setCellSelectionEnabled(false);
            this.pkgTable.setColumnSelectionAllowed(false);
            this.pkgTable.setRowSelectionAllowed(false);
            this.pkgTable.setFocusable(false);
            this.pkgTable.getTableHeader().setReorderingAllowed(false);
            this.sorter.setTableHeader(this.pkgTable.getTableHeader());
            this.scrollArea.getViewport().setBackground(this.getBackground());
            this.scrollArea.getViewport().add(this.pkgTable);
            JPanel jPanel = new JPanel(new FlowLayout(2));
            jPanel.add(this.refresh);
            jPanel.add(this.close);
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.getContentPane().add((Component)this.scrollArea, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.getContentPane().add((Component)jPanel, gridBagConstraints);
            this.setDefaultCloseOperation(2);
            this.getRootPane().setDefaultButton(this.close);
            this.setMinimumSize(new Dimension(300, 350));
            this.setLocation(200, 10);
            this.setSize(420, 450);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void dispose() {
        instance = null;
        super.dispose();
    }

    public static void showInstance() {
        if (instance == null) {
            instance = new JGRPackageManager();
        }
        instance.refresh();
        instance.setVisible(true);
    }

    public void exit() {
        this.setDefaultPackages();
        JGRPrefs.writePrefs(false);
        this.dispose();
    }

    public void refresh() {
        this.setWorking(true);
        this.setDefaultPackages();
        this.Packages = RController.refreshPackages();
        this.pkgModel = new PTableModel(this);
        this.sorter = new TableSorter(this.pkgModel);
        this.pkgTable.setModel(this.sorter);
        this.sorter.setTableHeader(this.pkgTable.getTableHeader());
        this.setWorking(false);
    }

    private void setPKGStatus(String string, String string2) {
        this.setWorking(true);
        if (string2.equals("true")) {
            JGR.MAINRCONSOLE.execute("library(" + string + ")", true);
        } else {
            JGR.MAINRCONSOLE.execute("detach(\"package:" + string + "\")", true);
        }
        this.setWorking(false);
    }

    private void setDefaultPackages() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.pkgModel.getRowCount(); ++i) {
            if (!this.pkgModel.getValueAt(i, 1).toString().equals("true")) continue;
            arrayList.add(this.pkgModel.getValueAt(i, 2));
        }
        defaultPackages = arrayList.toArray();
    }

    private String getSelectedPackages() {
        String string = "";
        for (int i = 0; i < this.MPackages.length; ++i) {
            if (!new Boolean(this.MPackages[i][0].toString()).booleanValue()) continue;
            string = string + "\"" + this.MPackages[i][1] + "\",";
        }
        return string.trim().length() > 0 ? string.substring(0, string.length() - 1) : null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "dontremind") {
            remindPackages = null;
            this.dispose();
        } else if (string == "exit") {
            this.exit();
        } else if (string == "instlater") {
            remindPackages = this.getSelectedPackages();
            if (remindPackages != null) {
                remindPackages = remindPackages.replaceAll("\"", "");
            }
            this.dispose();
        } else if (string == "instnow") {
            this.dispose();
            remindPackages = null;
            JGR.MAINRCONSOLE.execute("install.packages(c(" + this.getSelectedPackages() + "))", true);
        } else if (string == "refresh") {
            this.refresh();
        }
    }

    static {
        neededPackages = new HashMap();
        remindPackages = null;
    }

    class PTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = 3352499532040543693L;

        public void addColumn(TableColumn tableColumn) {
            if (tableColumn.getModelIndex() == 0 || tableColumn.getModelIndex() == 1) {
                tableColumn.setMinWidth(50);
                tableColumn.setPreferredWidth(50);
                tableColumn.setMaxWidth(50);
            } else if (tableColumn.getModelIndex() == 2) {
                tableColumn.setMinWidth(100);
                tableColumn.setMaxWidth(100);
            }
            super.addColumn(tableColumn);
        }
    }

    class PTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 4696543490603572692L;
        public int cols;
        public int rows;

        public PTableModel(JGRPackageManager jGRPackageManager2) {
            this.cols = jGRPackageManager2.columnNames.length;
            this.rows = jGRPackageManager2.Packages.length;
        }

        public Object getValueAt(int n, int n2) {
            return JGRPackageManager.this.Packages[n][n2];
        }

        public int getColumnCount() {
            return this.cols;
        }

        public int getRowCount() {
            return this.rows;
        }

        public void setValueAt(Object object, int n, int n2) {
            String string;
            if (n2 == 0) {
                JGRPackageManager.this.setPKGStatus(this.getValueAt(n, 2).toString(), object.toString());
            }
            if (n2 == 1 && neededPackages.containsKey(string = this.getValueAt(n, 2).toString())) {
                object = new Boolean(true);
            }
            ((JGRPackageManager)JGRPackageManager.this).Packages[n][n2] = object;
        }

        public String getColumnName(int n) {
            return JGRPackageManager.this.columnNames[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 <= 1;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    class PMTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = -3303539682530550720L;

        PMTableColumnModel() {
        }

        public void addColumn(TableColumn tableColumn) {
            if (tableColumn.getModelIndex() == 0) {
                tableColumn.setMinWidth(50);
                tableColumn.setPreferredWidth(50);
                tableColumn.setMaxWidth(50);
            }
            super.addColumn(tableColumn);
        }
    }

    class PMTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 7291256867075798679L;
        public int cols;
        public int rows;

        public PMTableModel(JGRPackageManager jGRPackageManager2) {
            this.rows = jGRPackageManager2.MPackages.length;
        }

        public Object getValueAt(int n, int n2) {
            return JGRPackageManager.this.MPackages[n][n2];
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.rows;
        }

        public void setValueAt(Object object, int n, int n2) {
            ((JGRPackageManager)JGRPackageManager.this).MPackages[n][n2] = object;
        }

        public String getColumnName(int n) {
            return n == 0 ? " " : "Package";
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 <= 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

