/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.models;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.models.GLMModel;
import org.rosuda.deducer.models.RModel;
import org.rosuda.deducer.toolkit.DJList;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class GLMExplorerMeans
extends JDialog
implements ActionListener {
    private JPanel termPanel;
    private JList terms;
    private JPanel meansPanel;
    private JPanel okayCancel;
    private JCheckBox confInt;
    private JScrollPane meansScroller;
    private JButton remove;
    private JButton add;
    private JList effects;
    private JScrollPane termScroller;
    GLMModel model;

    public GLMExplorerMeans(JFrame jFrame, GLMModel gLMModel, RModel rModel) {
        super(jFrame);
        this.initGUI();
        this.setModel(gLMModel, rModel);
        this.setModal(true);
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(null);
            this.termPanel = new JPanel();
            BorderLayout borderLayout = new BorderLayout();
            this.termPanel.setLayout(borderLayout);
            this.getContentPane().add(this.termPanel);
            this.termPanel.setBounds(12, 12, 170, 230);
            this.termPanel.setBorder(BorderFactory.createTitledBorder("Model Terms"));
            this.termScroller = new JScrollPane();
            this.termPanel.add((Component)this.termScroller, "Center");
            DefaultListModel defaultListModel = new DefaultListModel();
            this.terms = new DJList();
            this.termScroller.setViewportView(this.terms);
            this.terms.setModel(defaultListModel);
            this.meansPanel = new JPanel();
            borderLayout = new BorderLayout();
            this.meansPanel.setLayout(borderLayout);
            this.getContentPane().add(this.meansPanel);
            this.meansPanel.setBounds(250, 12, 170, 230);
            this.meansPanel.setBorder(BorderFactory.createTitledBorder("Effects"));
            this.meansScroller = new JScrollPane();
            this.meansPanel.add((Component)this.meansScroller, "Center");
            defaultListModel = new DefaultListModel();
            this.effects = new DJList();
            this.meansScroller.setViewportView(this.effects);
            this.effects.setModel(defaultListModel);
            this.add = new IconButton("/icons/1rightarrow_32.png", "Add", this, "Add");
            this.getContentPane().add(this.add);
            this.add.setBounds(197, 86, 38, 38);
            this.remove = new IconButton("/icons/1leftarrow_32.png", "Remove", this, "Remove");
            this.getContentPane().add(this.remove);
            this.remove.setBounds(197, 124, 38, 38);
            this.confInt = new JCheckBox();
            this.getContentPane().add(this.confInt);
            this.confInt.setText("Estimate confidence intervals");
            this.confInt.setBounds(132, 259, 250, 19);
            this.okayCancel = new OkayCancelPanel(false, false, this);
            this.getContentPane().add(this.okayCancel);
            this.okayCancel.setBounds(209, 297, 207, 36);
            this.setTitle("Post-Hoc Comparisons");
            this.setSize(432, 379);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void updateModel() {
        this.model.effects.effects = (DefaultListModel)this.effects.getModel();
        this.model.effects.confInt = this.confInt.isSelected();
    }

    public void setModel(GLMModel gLMModel, RModel rModel) {
        int n;
        this.model = gLMModel;
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        String[] stringArray = Deducer.rniEval("attr(terms(" + rModel.modelName + "),\"term.labels\")").asStringArray();
        for (n = 0; n < stringArray.length; ++n) {
            defaultListModel.addElement(stringArray[n]);
        }
        this.terms.setModel(defaultListModel);
        for (n = 0; n < this.model.effects.effects.getSize(); ++n) {
            if (!defaultListModel.contains(this.model.effects.effects.elementAt(n))) continue;
            defaultListModel.removeElement(this.model.effects.effects.elementAt(n));
            ((DefaultListModel)this.effects.getModel()).addElement(this.model.effects.effects.elementAt(n));
        }
        this.confInt.setSelected(this.model.effects.confInt);
    }

    public void disableConfInt() {
        this.confInt.setEnabled(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block3: {
            String string;
            block5: {
                block4: {
                    block2: {
                        string = actionEvent.getActionCommand();
                        if (string != "Cancel") break block2;
                        this.dispose();
                        break block3;
                    }
                    if (string != "OK") break block4;
                    this.updateModel();
                    this.dispose();
                    break block3;
                }
                if (string != "Add") break block5;
                Object[] objectArray = this.terms.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((DefaultListModel)this.terms.getModel()).removeElement(objectArray[i]);
                    if (objectArray[i] == null) continue;
                    ((DefaultListModel)this.effects.getModel()).addElement(objectArray[i]);
                }
                break block3;
            }
            if (string != "Remove") break block3;
            Object[] objectArray = this.effects.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                ((DefaultListModel)this.effects.getModel()).removeElement(objectArray[i]);
                if (objectArray[i] == null) continue;
                ((DefaultListModel)this.terms.getModel()).addElement(objectArray[i]);
            }
        }
    }
}

