% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neural_meta_learners.R
\name{metalearner_deepneural}
\alias{metalearner_deepneural}
\title{metalearner_deepneural}
\usage{
metalearner_deepneural(
  data,
  cov.formula,
  treat.var,
  meta.learner.type,
  stepmax = 1e+05,
  nfolds = 5,
  algorithm = "rprop+",
  hidden.layer = c(4, 2),
  linear.output = FALSE,
  binary.outcome = TRUE
)
}
\arguments{
\item{data}{\code{data.frame} object of data.}

\item{cov.formula}{formula description of the model y ~ x(list of covariates).}

\item{treat.var}{string for the name of treatment variable.}

\item{meta.learner.type}{string specifying is the S-learner and
\code{"T.Learner"} for the T-learner model.}

\item{stepmax}{maximum number of steps for training model.}

\item{nfolds}{number of folds for cross-validation. Currently supports up to
5 folds.}

\item{algorithm}{a string for the algorithm for the neural network.
Default set to \verb{rprop+}, the Resilient back propagation (Rprop) with weight
backtracking algorithm for training neural networks.}

\item{hidden.layer}{vector of integers specifying layers and number of neurons.}

\item{linear.output}{logical specifying regression (TRUE)
or classification (FALSE) model.}

\item{binary.outcome}{logical specifying predicted outcome variable will take
binary values or proportions.}
}
\value{
\code{list} of predicted outcome values and CATEs estimated by the meta
learners for each observation.#' @export
}
\description{
\code{metalearner_deepneural} implements the S-learner and T-learner for estimating
CATE using Deep Neural Networks. The Resilient back propagation (Rprop)
algorithm is used for training neural networks.
}
\examples{
\donttest{
# load dataset
data(exp_data)
# estimate CATEs with S Learner
set.seed(123456)
slearner_nn <- metalearner_deepneural(cov.formula = support_war ~ age + income +
                                   employed  + job_loss,
                                   data = exp_data,
                                   treat.var = "strong_leader",
                                   meta.learner.type = "S.Learner",
                                   stepmax = 2e+9,
                                   nfolds = 5,
                                   algorithm = "rprop+",
                                   hidden.layer = c(1),
                                   linear.output = FALSE,
                                   binary.outcome = TRUE)


# load dataset
set.seed(123456)
# estimate CATEs with T Learner
tlearner_nn <- metalearner_deepneural(cov.formula = support_war ~ age +
                                  income  +
                                  employed  + job_loss,
                                  data = exp_data,
                                  treat.var = "strong_leader",
                                  meta.learner.type = "T.Learner",
                                  stepmax = 1e+9,
                                  nfolds = 5,
                                  algorithm = "rprop+",
                                  hidden.layer = c(2,1),
                                  linear.output = FALSE,
                                  binary.outcome = TRUE)
                                  }

}
