% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetB.R
\name{GetB}
\alias{GetB}
\title{Calculate B function}
\usage{
GetB(mx, tol = 1e-12, maxits = 1000)
}
\arguments{
\item{mx}{Matrix. Modified matrix to have a solution Usually GetMx$M2.}

\item{tol}{Double number. Indicate the precision of the numeric method to calculate B. Expected to be 1e-6 <= tol <= 1e-15.Default is 1e-12.}

\item{maxits}{Whole number. Indicate the maximum number of iterations of the numeric method to calculate B. Expected to be 100 <= maxits <= 5000. Default is 1000.}
}
\description{
This function solve numericaly the non lineal inequation of the Delta system. Also return the s(i) values of the equation.
}
\examples{
GetB(mx = matrix(c(1,0,0,0,2,0,0,0,3),3,3),tol = 1e-12, maxits = 1000)
GetB(mx = matrix(c(1,2,0,3,4,0,0,0,1),3,3),tol = 1e-12, maxits = 1000)
}
\keyword{B}
\keyword{Delta}
\keyword{maxits}
\keyword{mx}
\keyword{tol}
