% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_structure.R
\name{save_api_key}
\alias{save_api_key}
\title{Saves the API key for future functions}
\usage{
save_api_key(key)
}
\arguments{
\item{key}{API key obtained from the specific website. Visit the one of the following
websites to obtain an API key: \itemize{ \item
\href{https://store.agify.io/signup}{genderize.io} \item
\href{https://store.agify.io/signup}{agify.io} \item
\href{https://nationalize.io/signup}{nationalize.io}}}
}
\value{
Does save the key in the environment.
}
\description{
Saves the all in one genderize.io, agify.io & nationalize.io API
  key in the users environment. It has the advantage that it is not
  necessary to explicitly publish the key in the users code. Just do it one
  time and you're set. To update the key just save again and it will
  overwrite the old key. To explicitly print the key, use the
  \code{\link{get_api_key}} function. To remove the key use the
  \code{\link{remove_api_key}} function.
}
\section{Warning}{
 Please be careful when dealing with API keys and other
  secrets & tokens - keep them private and do not publish them.
}

\examples{
\dontrun{
save_api_key(key="__YOUR_API_KEY__")
}
}
\seealso{
\code{\link{get_api_key}}, \code{\link{remove_api_key}}
}
\author{
Matthias Brenninkmeijer -
  \href{https://github.com/matbmeijer}{https://github.com/matbmeijer}
}
