% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DepLogoR.R
\name{getDeps}
\alias{getDeps}
\title{Compute dependencies between positions}
\usage{
getDeps(data, ...)
}
\arguments{
\item{data}{the data for computing mutual information. Either a DLData object
or a data.frame. In the latter case, the symbols of the alphabet must be
provided as a second parameter.}

\item{...}{the symbols of the alphabet as character vector, only if data is a
data.frame}
}
\value{
A matrix of the mutual information values, where the diagonal is
  fixed to zero.
}
\description{
Computes the dependencies (as measures by mutual information) between all
positions (columns) of discrete data. Specifically, it returns for each pair
of positions (i,j) the mutual information I(X_i,X_j) multiplied by the number
N of sequences (rows), which may also be used for testing the statistical
significance of mutual information values, as for large N, 2*N*I(X_i,X_j) is
approximately chi squared.
}
\examples{
data <- DLData(c("ACGT", "ATTA"))
deps <- getDeps(data)


}
\author{
Jan Grau <grau@informatik.uni-halle.de>
}
