% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DepLogoR.R
\name{suggestColors}
\alias{suggestColors}
\title{Suggest colors for symbols}
\usage{
suggestColors(data)
}
\arguments{
\item{data}{the data}
}
\value{
the colors
}
\description{
Suggests colors for the symbols in \code{data} based on the co-occurrence of
symbols at common positions, weighted by the dependency values at those positions.
The idea is to assign similar colors only to symbols that either mostly occur at 
different positions or that are present at positions with low inter-dependencies 
to other positions.
}
\examples{
# read data and create DLData object
seqs <- read.table(system.file("extdata", "cjun.txt", package = "DepLogo"), 
    stringsAsFactors = FALSE)
data <- DLData(sequences = seqs[, 1] ,weights = log1p(seqs[, 2]) )

suggestColors(data)
}
\seealso{
\link{replaceColors}
}
\author{
Jan Grau <grau@informatik.uni-halle.de>
}
