% Generated by roxygen2 (4.0.1): do not edit by hand
\name{depthProjection}
\alias{depthProjection}
\title{Projection Depth}
\usage{
depthProjection(u, X, ndir = 1000, name = "X", threads = -1, ...)
}
\arguments{
\item{u}{Numerical vector or matrix whose depth is to be calculated. Dimension has to be the same as that of the observations.}

\item{X}{The data as a matrix, data frame or list. If it is a matrix or data frame, then each row is viewed as one multivariate observation. If it is a list, all components must be numerical vectors of equal length (coordinates of observations).}

\item{ndir}{number of directions used in computations}

\item{threads}{number of threads used in parallel computations. Default value -1 means that all possible cores will be used.}

\item{name}{name for this data set - it will be used on plots from depthproc.}

\item{\dots}{currently not supported.}
}
\description{
Computes the Projection depth of a point or vectors of points with respect to a multivariate data set.
}
\details{
Irrespective of dimension, Projection and Tukey's depth is obtained by approximate calculation.

 Returns the depth of multivariate point \code{u} with respect to data set \code{X}.
}
\examples{
x <- matrix(rnorm(3000), nc = 3)

 #Same results
 set.seed(1)
 a = depthProjection(x, x, ndir = 2000)
 set.seed(1)
 b = depthProjection(x, x, ndir = 2000)
 all(a == b)
 #Different
 depthProjection(x, x, ndir = 2000) == depthProjection(x, x, ndir = 2000)
}
\author{
Daniel Kosiorowski, Mateusz Bocian, Anna Wegrzynkiewicz and Zygmunt Zawadzki from Cracow University of Economics.
}
\keyword{depth}
\keyword{function}
\keyword{multivariate}
\keyword{nonparametric}

