% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DF_train.R
\name{DF_train}
\alias{DF_train}
\title{Decision Forest algorithm: Model training}
\usage{
DF_train(X, Y, stop_step = 2, Max_tree = 20, Discard = "All",
  Filter = F, p_val = 0.05, Method = "bACC", Quiet = T,
  Grace_ACC = 0.05, imp_ACC_accu = 0.01, Grace_bACC = 0.05,
  imp_bACC_accu = 0.01, Grace_MCC = 0.05, imp_MCC_accu = 0.01,
  Grace_MIS = ceiling(0.05 * length(Y)), imp_MIS_accu = ceiling(0.01 *
  length(Y)))
}
\arguments{
\item{X}{Training Dataset}

\item{Y}{Training data endpoint}

\item{stop_step}{How many extra step would be processed when performance not improved, 1 means one extra step}

\item{Max_tree}{Maximum tree number in Forest}

\item{Discard}{All: Discard all used features in previous tree; One: Only discard the first feature in prevouos tree; N (integer): Discard first N features}

\item{Filter}{doing feature selection before training}

\item{p_val}{P-value threshold measured by t-test used in feature selection, default is 0.05}

\item{Method}{Which is used for evaluating training process. MIS: Misclassification rate; ACC: accuracy}

\item{Quiet}{if TRUE (default), don't show any message during the process}

\item{Grace_ACC}{Grace Value in evaluation: the next model should have a performance (Accuracy) not bad than previous model with threshold}

\item{imp_ACC_accu}{improvement in evaluation: adding new tree should improve the overall model performance (accuracy) by threshold}

\item{Grace_bACC}{Grace Value in evaluation: (Balanced Accuracy)}

\item{imp_bACC_accu}{improvement in evaluation: (Balanced Accuracy)}

\item{Grace_MCC}{Grace Value in evaluation: (MCC)}

\item{imp_MCC_accu}{improvement in evaluation: (MCC)}

\item{Grace_MIS}{Grace Value in evaluation: (MIS)}

\item{imp_MIS_accu}{improvement in evaluation: (MIS)}
}
\value{
.$accuracy:     Overall training accuracy

.$pred:         Detailed training prediction (fitting)

.$detail:       Detailed usage of Decision tree Features/Models and their performances

.$models:       Constructed (list of) Decision tree models
}
\description{
Decision Forest algorithm: Model training
}
\examples{
  ##data(iris)
  X = iris[,1:4]
  Y = iris[,5]
  names(Y)=rownames(X)
  used_model = DF_train(X,Y,stop_step=4, Method = "MCC")

}

