% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiSCoTEA.R
\name{DiSCoT}
\alias{DiSCoT}
\title{Store aggregated treatment effects}
\usage{
DiSCoT(
  agg,
  treats,
  ses,
  grid,
  ci_lower,
  ci_upper,
  t0,
  call,
  cl,
  N,
  J,
  agg_df,
  perm,
  plot
)
}
\arguments{
\item{agg}{aggregation method}

\item{treats}{list of treatment effects}

\item{ses}{list of standard errors}

\item{grid}{grid}

\item{ci_lower}{list of lower confidence intervals}

\item{ci_upper}{list of upper confidence intervals}

\item{t0}{start time}

\item{call}{call}

\item{cl}{confidence level}

\item{N}{number of observations}

\item{J}{number of treated units}

\item{agg_df}{dataframe of aggregated treatment effects and their confidence intervals}

\item{perm}{list of per mutation results}

\item{plot}{a ggplot object containing the plot for the aggregated treatment effects using the \code{agg} parameter}
}
\value{
S3 object of class \code{DiSCoT} with associated \code{summary} and \code{print} methods
}
\description{
S3 object holding aggregated treatment effects
}
