% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_articulation_points.R
\name{get_articulation_points}
\alias{get_articulation_points}
\title{Get articulation points}
\usage{
get_articulation_points(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a vector of node IDs.
}
\description{
Get the nodes in the graph that are
identified as articulation points.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
  30, 50, set_seed = 1)

# Get the articulation points in the graph (i.e.,
# those nodes that if any were to be removed, the
# graph would become disconnected)
get_articulation_points(graph)
#> [1] "8"  "22" "24"
}

