% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_edge.R
\name{add_edge}
\alias{add_edge}
\title{Add an edge between nodes in a graph object}
\usage{
add_edge(graph, from, to, rel = NULL, use_labels = FALSE)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{from}{the outgoing node from which the edge
is connected.}

\item{to}{the incoming nodes to which each edge
is connected.}

\item{rel}{an optional string specifying the
relationship between the
connected nodes.}

\item{use_labels}{an option to use node \code{label}
values in \code{from} and \code{to} for defining
node connections. Note that this is only possible
if all nodes have distinct \code{label} values set
and none exist as an empty string.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
With a graph object of class
\code{dgr_graph}, add an edge to nodes within the
graph.
}
\examples{
# Create a graph with 4 nodes
graph <-
  create_graph() \%>\%
  add_node(label = "one") \%>\%
  add_node(label = "two") \%>\%
  add_node(label = "three") \%>\%
  add_node(label = "four")

# Add an edge between those nodes and attach a
# relationship to the edge
graph <-
 add_edge(
   graph,
   from = 1,
   to = 2,
   rel = "A")

# Use the `edge_info()` function to verify that
# the edge has been created
edge_info(graph)
#>   id from to rel
#> 1  1    1  2   A

# Add another node and edge to the graph
graph <-
  graph \%>\%
  add_edge(3, 2, "A")

# Verify that the edge has been created by
# getting a count of graph edges
edge_count(graph)
#> [1] 2

# Add edges by specifying node `label` values
# and setting `use_labels = TRUE`; note
# that all nodes must have unique `label`
# values to use this option
graph <-
  graph \%>\%
  add_edge(
    "three", "four", "L",
    use_labels = TRUE) \%>\%
  add_edge(
    "four", "one", "L",
    use_labels = TRUE)

# Use the `get_edges()` function to verify
# that the edges were added
get_edges(graph)
#> [1] "1->2" "3->2" "3->4" "4->1"
}

