% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_edge_attrs.R
\name{cache_edge_attrs}
\alias{cache_edge_attrs}
\title{Cache edge attributes in the graph}
\usage{
cache_edge_attrs(graph, edge_attr, mode = NULL, from = NULL, to = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{edge_attr}{the edge attribute from which to
obtain values.}

\item{mode}{a option to recast the returned vector
of edge attribute value as \code{numeric} or
\code{character}.}

\item{from}{an optional vector of node IDs from
which the edge is outgoing for filtering the list of
edges present in the graph.}

\item{to}{an optional vector of node IDs to which
the edge is incoming for filtering the list of
edges present in the graph.}
}
\value{
a graph object of class \code{dgr_graph}.
# Set a seed
set.seed(25)

# Create a graph with 10 nodes and 9 edges
graph <-
  create_graph() %>%
  add_n_nodes(10) %>%
  add_edges_w_string(
    "1->2 1->3 2->4 2->5 3->6 3->7
     4->8 4->9 5->10") %>%
  set_edge_attrs(
    "value", rnorm(edge_count(.), 5, 2))

# Cache all values from the edge attribute `value`
# as a numeric vector
graph <-
  graph %>%
  cache_edge_attrs("value", "numeric")

# Get the mean from all values available in
# the cache
graph %>% get_cache() %>% mean()
#> [1] 4.62536
}
\description{
From a graph object of class
\code{dgr_graph}, get edge attribute properties for
one or more edges and cache those values in the
graph for later retrieval using \code{get_cache}.
}

