% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale_node_attrs.R
\name{rescale_node_attrs}
\alias{rescale_node_attrs}
\title{Rescale numeric node attribute values}
\usage{
rescale_node_attrs(graph, node_attr_from, to_lower_bound = 0,
  to_upper_bound = 1, node_attr_to = NULL, from_lower_bound = NULL,
  from_upper_bound = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{node_attr_from}{the node attribute containing
numeric data that is to be rescaled to new numeric
or color values.}

\item{to_lower_bound}{the lower bound value for the
set of rescaled values. This can be a numeric value
or an X11 color name.}

\item{to_upper_bound}{the upper bound value for the
set of rescaled values. This can be a numeric value
or an X11 color name.}

\item{node_attr_to}{an optional name of a new node
attribute to which the recoded values will be
applied. This will retain the original node
attribute and its values.}

\item{from_lower_bound}{an optional, manually set
lower bound value for the rescaled values. If not
set, the minimum value from the set will be used.}

\item{from_upper_bound}{an optional, manually set
upper bound value for the rescaled values. If not
set, the minimum value from the set will be used.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class
\code{dgr_graph}, take a set of numeric values for a
node attribute, rescale to a new numeric or color
range, then write to the same node attribute or to
a new node attribute column.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    5, 10, set_seed = 3,
    directed = TRUE)

# Get the graph's internal ndf to show which
# node attributes are available
get_node_df(graph)
#>   id type label value
#> 1  1 <NA>     1   2.0
#> 2  2 <NA>     2   8.5
#> 3  3 <NA>     3   4.0
#> 4  4 <NA>     4   3.5
#> 5  5 <NA>     5   6.5

# Rescale the `value` node attribute, so that
# its values are rescaled between 0 and 1
graph <-
  graph \%>\%
  rescale_node_attrs("value")

# Get the graph's internal ndf to show that the
# node attribute values had been rescaled
get_node_df(graph)
#>   id type label value
#> 1  1 <NA>     1 0.000
#> 2  2 <NA>     2 1.000
#> 3  3 <NA>     3 0.308
#> 4  4 <NA>     4 0.231
#> 5  5 <NA>     5 0.692

# Scale the values in the `value` node attribute
# to different shades of gray for the `fillcolor`
# and `fontcolor` node attributes
graph <-
  graph \%>\%
  rescale_node_attrs(
    "value", "gray80", "gray20", "fillcolor") \%>\%
  rescale_node_attrs(
    "value", "gray5", "gray95", "fontcolor")

# Get the graph's internal ndf once more to show
# that scaled grayscale colors are now available in
# the `fillcolor` and `fontcolor` node attributes
get_node_df(graph)
#>   id type label value fillcolor fontcolor
#> 1  1 <NA>     1 0.000   #CCCCCC   #0D0D0D
#> 2  2 <NA>     2 1.000   #333333   #F2F2F2
#> 3  3 <NA>     3 0.308   #999999   #4B4B4B
#> 4  4 <NA>     4 0.231   #A6A6A6   #3B3B3B
#> 5  5 <NA>     5 0.692   #5E5E5E   #A4A4A4
}

