% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_graph_series.R
\name{create_graph_series}
\alias{create_graph_series}
\title{Create a graph series object}
\usage{
create_graph_series(graph = NULL, series_name = NULL,
  series_type = "sequential")
}
\arguments{
\item{graph}{a graph object to add to the new
graph series object.}

\item{series_name}{an optional name to ascribe to
the series.}

\item{series_type}{either a \code{sequential} type
(the default) or a \code{temporal} type (which
requires date-time strings and time zone codes
to be supplied).}
}
\value{
a graph series object of type
\code{dgr_graph_1D}.
}
\description{
Create a graph series object for the
storage of multiple graphs across a sequential or
temporal one-dimensional array.
}
\examples{
# Create three graphs
graph_1 <-
  create_graph() \%>\%
  add_path(n = 4)

graph_2 <-
  create_graph() \%>\%
  add_cycle(n = 5)

graph_3 <-
  create_graph() \%>\%
  add_star(n = 6)

# Create an empty graph series
# and add the graphs
series <-
  create_graph_series() \%>\%
  add_graph_to_graph_series(
    graph = graph_1) \%>\%
  add_graph_to_graph_series(
    graph = graph_2) \%>\%
  add_graph_to_graph_series(
    graph = graph_3)

# Count the number of graphs
# in the graph series
series \%>\%
  count_graphs_in_graph_series()
}
