% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_node.R
\name{delete_node}
\alias{delete_node}
\title{Delete a node from an existing graph object}
\usage{
delete_node(graph, node)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{node}{A node ID for the node to be deleted from the graph.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class \code{dgr_graph}, delete an existing node by
specifying its node ID.
}
\examples{
# Create a graph with 5 nodes and
# edges between each in a path
graph <-
  create_graph() \%>\%
  add_path(n = 5)

# Delete node with ID `3`
graph <- delete_node(graph, node = 3)

# Verify that the node with ID `3`
# is no longer in the graph
graph \%>\% get_node_ids()

# Also note that edges are removed
# since there were edges between the
# removed node to and from other nodes
graph \%>\% get_edges()
}
\seealso{
Other Node creation and removal: 
\code{\link{add_n_node_clones}()},
\code{\link{add_n_nodes_ws}()},
\code{\link{add_n_nodes}()},
\code{\link{add_node_clones_ws}()},
\code{\link{add_node_df}()},
\code{\link{add_nodes_from_df_cols}()},
\code{\link{add_nodes_from_table}()},
\code{\link{add_node}()},
\code{\link{colorize_node_attrs}()},
\code{\link{copy_node_attrs}()},
\code{\link{create_node_df}()},
\code{\link{delete_nodes_ws}()},
\code{\link{drop_node_attrs}()},
\code{\link{join_node_attrs}()},
\code{\link{layout_nodes_w_string}()},
\code{\link{mutate_node_attrs_ws}()},
\code{\link{mutate_node_attrs}()},
\code{\link{node_data}()},
\code{\link{recode_node_attrs}()},
\code{\link{rename_node_attrs}()},
\code{\link{rescale_node_attrs}()},
\code{\link{set_node_attr_to_display}()},
\code{\link{set_node_attr_w_fcn}()},
\code{\link{set_node_attrs_ws}()},
\code{\link{set_node_attrs}()},
\code{\link{set_node_position}()}
}
\concept{Node creation and removal}
