% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sens.R
\name{cdesens}
\alias{cdesens}
\title{Estimate sensitivity of ACDE estimates under varying levels of unobserved confounding}
\usage{
cdesens(seqg, var, rho = seq(-0.9, 0.9, by = 0.05),
  bootstrap = c("none", "standard"), boots_n = 1000, verbose = FALSE,
  ...)
}
\arguments{
\item{seqg}{Output from sequential_g. The function only supports specifications with one
mediator variable.}

\item{var}{A character indicating the name of the variable for
which the estimated ACDE is being evaluated.}

\item{rho}{A numerical vector of correlations between errors to test for. The
original model assumes \env{rho = 0}}

\item{bootstrap}{character of c("none", "standard"), indicating whether to
include bootstrap standard errors. Default is "none".}

\item{boots_n}{Number of bootstrap replicates, defaults to 100.}

\item{verbose}{Whether to show progress and messages, defaults to
\env{FALSE}}

\item{...}{Other parameters to pass on to \env{lm.fit()} when
refitting the model}
}
\description{
Estimate how the Average Controlled Direct Effect varies by various levels of
unobserved confounding. For each value of unmeasured confounding, summarized as
a correlation between residuals, \env{cdesens} computes the ACDE. Standard
errors are computed by a simple bootstrap.
}
\examples{
data(civilwar)


# main formula: Y ~ A + X | Z | M
form_main <- onset ~ ethfrac + lmtnest + ncontig + Oil | warl +
  gdpenl + lpop + polity2l + relfrac | instab

# estimate CDE
direct <- sequential_g(form_main, data = civilwar)

# sensitivity
out_sens <- cdesens(direct, var = "ethfrac")

# plot sensitivity
plot(out_sens)

}
