\name{DR_data}
\alias{DR_data}
\alias{print.DirichletRegData}
\alias{getdata}
\title{Prepare Compositional Data}
\description{This function prepares a matrix with compositional variables for further
  processing in the \code{DirichletReg} package.
}
\usage{
DR_data(data, trafo = FALSE, base = 1)

\method{print}{DirichletRegData}(x, \ldots)

getdata(object, orig = FALSE)
}
\arguments{
  \item{data}{a \code{matrix} or \code{data.frame} of all compositional variables}
  \item{trafo}{transform variables to shrink away from extreme values of 0 and 1}
  \item{base}{the `base' variable to use in the reparametrized model}
  \item{x}{an object generated by \code{DR_data}}
  \item{\ldots}{further arguments}
  \item{object}{a \code{DirichletRegData} object}
  \item{orig}{a logical value indicating whether the original data (without
              \code{NA}s) or the transformed and normalized data are returned}
}
\details{
The transformation (done if \code{trafo} is \code{TRUE}) is a generalization of
that proposed by Smithson and Verkuilen (2006) that transforms each component
\eqn{y}{y} of \eqn{Y}{Y} by computing \eqn{y^{*}=\frac{y(n-1)+\frac{1}{2}}{n}}{y*=[y(n-1)+1/2]/n}
where \eqn{n}{n} is the number of observations in \eqn{Y}{Y} (this approach is used in \code{betareg}, see ).
For an arbitrary number of dimensions (or variables) \eqn{d}{d} the transformation
is carried out by \eqn{y^{*}=\frac{y(n-1)+\frac{1}{d}}{n}}{y*=[y(n-1)+1/d]/n}.
}
\value{The function returns an object of class \code{DirichletRegData} containing a list of 5 elements:
  \item{Y}{the actual (possibly transformed or normalized) data}
  \item{Y.orig}{the original data}
  \item{dims}{number of dimensions of \code{Y} (i.e. number of columns)}
  \item{obs}{number of observations of \code{Y} (i.e. number of rows)}
  \item{excluded}{is either \code{NULL}, if all observations can be used, or contains a logical vector where \code{TRUE} means the exclusion of an observation due to missing values}
  \item{normalized}{a logical value indicating whether the data were normalized}
  \item{transformed}{a logical value indicating whether the data were transformed}
  \item{base}{number of the variable used as the base in the reparametrized model}
}
\references{
Smithson, M. & Verkuilen, J. (2006). A Better Lemon Squeezer? Maximum-Likelihood Regression With Beta-Distributed Dependent Variables. \emph{Psychological Methods, 11}(1), 54--71.

Cribari-Neto, F. & Zeileis, A. (2010). Beta Regression in R. \emph{Journal of Statistical Software, 34}(2), 1--24.
}
\author{
  Marco Maier
}
%\note{
%%  ~~further notes~~
%}
%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%}
\examples{
# create a DirichletRegData object from the Arctic Lake data
AL <- DR_data(ArcticLake[, 1:3])
AL

# extract the original data and print the first rows
head(getdata(AL, orig = TRUE))
}
\keyword{manip}