% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistanceFuns.R
\name{distancematrix}
\alias{distancematrix}
\title{Function invoking discrete distance functions}
\usage{
distancematrix(X, d, na.rm = TRUE)
}
\arguments{
\item{X}{Matrix where rows are the observations and columns are discrete features}

\item{d}{Name of distance. Distances available: bhattacharyya, chisquare, cramerV, hamming and hellinger}

\item{na.rm}{Remove NAs default=TRUE}
}
\value{
R distance object
}
\description{
Function invoking discrete distance functions
}
\examples{
X = rbind(matrix(paste0("a", rpois(7*5, 1)), nrow=5),
          matrix(paste0("a", rpois(7*5, 3)), nrow=5))
distancematrix(X = X, d = "hellinger")
}
