% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_stats.R
\name{generate_stats}
\alias{generate_stats}
\title{Generate Diversity Index Statistics}
\usage{
generate_stats(clusterised_object)
}
\arguments{
\item{clusterised_object}{An object created by the clusterise_sites function.}
}
\value{
A dataframe where each row pertains to a site and each column has higher taxa labels, time & location data, as well as diversity index values.
}
\description{
Calculates diversity index values for each site in a clusterised object.
}
\examples{
# generate species count tables with a minimum of 30 individuals from 5 species
Colombia_Caquetá_dataframe <- subset(Colombia, stateProvince == "Caquetá")

clusterised_Caquetá <- clusterise_sites(dataframe = Colombia_Caquetá_dataframe,
                                       cluster_min_length = 30,
                                       group_radius = 20000
)

stats_Caquetá <- generate_stats(clusterised_Caquetá)

head(stats_Caquetá)
}
