% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/method-default.R
\name{initializeProvider}
\alias{initializeProvider}
\alias{initializeProvider,ANY-method}
\title{Initialize the service provider}
\usage{
initializeProvider(provider, cluster, verbose)

\S4method{initializeProvider}{ANY}(provider, cluster, verbose = 0L)
}
\arguments{
\item{provider}{S4 \code{CloudProvider} object. The service provider.}

\item{cluster}{S4 \code{DockerCluster} object.}

\item{verbose}{Integer. The verbose level, default 1.}
}
\value{
No return value
}
\description{
Initialize the service provider. This function will be called prior
to \code{runDockerServer} and \code{runDockerWorkers}. It is used to initialize the cloud-specific
settings(e.g. Initialize the cloud network). The function might be called many
times. Developers can cache the cloud status and speed up the initialization
process.
}
\details{
Based on the cloud nature, an initialization process might be required
before deploying the container on the cloud. This function will be called by
the \code{DockerCluster} object before running the server and workers. The default
method will do nothing.

Besides initializing the cloud settings, if the server container will be deployed
by the cloud provider. The function should call \code{.setServerWorkerSameLAN()} to inform
the \code{DockerCluster} object whether the server and the workers are under the same router.
If \code{.getServerWorkerSameLAN()} is \code{TRUE}(default), the worker will connect to the
server using the server's private IP. Otherwise, the server's
public IP will be used.

Although it is possible to change any settings in \code{cluster} in this function,
the best practice is to only initialize \code{provider} and
the value \code{serverWorkerSameLAN}.
}
\section{Functions}{
\itemize{
\item \code{initializeProvider,ANY-method}: The default cloud initialization method, do nothing.
}}

