% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/PCAVaR.R
\name{PCAVaR}
\alias{PCAVaR}
\title{Estimates VaR by principal components analysis}
\usage{
PCAVaR(Ra, position.data, number.of.principal.components, cl)
}
\arguments{
\item{Ra}{Matrix return data set where each row is interpreted as a set of daily observations, and each column as the returns to each position in a portfolio}

\item{position.data}{Position-size vector, giving amount invested in each position}

\item{number.of.principal.components}{Chosen number of principal components}

\item{cl}{Chosen confidence level}
}
\value{
VaR
}
\description{
Estimates the VaR of a multi position portfolio by principal components analysis, using chosen number of principal components and a specified confidence level or range of confidence levels.
}
\examples{
# Computes PCA VaR
   Ra <- matrix(rnorm(4*6),4,6)
   position.data <- rnorm(6)
   PCAVaR(Ra, position.data, 2, .95)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

