% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tVaRDFPerc.R
\name{tVaRDFPerc}
\alias{tVaRDFPerc}
\title{Percentiles of VaR distribution function}
\usage{
tVaRDFPerc(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
standard deviation data. Accordingly, number of input arguments is either 5
or 7. In case there 6 input arguments, the mean, standard deviation and
number of observations of the data is computed from return data. See examples
for details.

 returns Vector of daily geometric return data

 mu Mean of daily geometric return data

 sigma Standard deviation of daily geometric return data

 n Sample size

 perc Desired percentile

 df Number of degrees of freedom in the t distribution

 cl VaR confidence level and must be a scalar

 hp VaR holding period and must be a a scalar

 Percentiles of VaR distribution function}
}
\description{
Plots the VaR of a portfolio against confidence level assuming that P/L are
t- distributed, for specified confidence level and holding period.
}
\examples{
# Estimates Percentiles of VaR distribution
   data <- runif(5, min = 0, max = .2)
   tVaRDFPerc(returns = data, perc = .7,
                 df = 6, cl = .95, hp = 60)

   # Computes v given mean and standard deviation of return data
   tVaRDFPerc(mu = .012, sigma = .03, n= 10,
                 perc = .8, df = 6, cl = .99, hp = 40)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

