% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictMAR.R
\name{predictAutoMAR}
\alias{predictAutoMAR}
\title{Extract predictions and MAR columns from autoMAR objects}
\usage{
predictAutoMAR(x, data, mar_var = NULL)
}
\arguments{
\item{x}{[autoMAR object  | Required] autoMAR object for which prediction is desired}

\item{data}{[data.frame | Required] prediction data set to prepare the autoMAR outcomes}

\item{mar_var}{[character list | Optional] list of predefined mar variables}
}
\value{
flagged variables for missing not completely at random variable
}
\description{
this function can be used for autoMAR objects to generate the variable for missing variable not completely at random
}
\examples{
## Missing at random features
train <- heart[1 : 199, ]
test <- heart[200 : 300, ]
marobj <- autoMAR (train, aucv = 0.9, strataname = NULL, stratasize = NULL, mar_method = "glm")

## print summary in console
testobj <- predictAutoMAR(marobj, test)
}
