% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseIndication.R
\name{indicationColumns}
\alias{indicationColumns}
\title{Obtain automatically the indication columns}
\usage{
indicationColumns(x)
}
\arguments{
\item{x}{Tibble}
}
\value{
Name of the indication columns
}
\description{
Obtain automatically the indication columns
}
\examples{
\donttest{
library(DrugUtilisation)
library(CodelistGenerator)

cdm <- mockDrugUtilisation()
indications <- list("headache" = 378253, "asthma" = 317009)
cdm <- generateConceptCohortSet(cdm, indications, "indication_cohorts")
acetaminophen <- getDrugIngredientCodes(cdm, "acetaminophen")
cdm <- generateDrugUtilisationCohortSet(cdm, "drug_cohort", acetaminophen)
cdm$drug_cohort <- cdm$drug_cohort \%>\%
  addIndication(cdm, "indication_cohorts", indicationGap = c(0, 30, 365))

indicationColumns(cdm$drug_cohort)
}

}
