% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/B_TxSubset.R
\name{TxSubset-methods}
\alias{TxSubset-methods}
\alias{.convertFromBinary,TxSubset-method}
\alias{.convertToBinary,TxSubset-method}
\alias{.getPtsSubset,TxSubset-method}
\alias{.getSingleton,TxSubset-method}
\alias{.getSubsetRule,TxSubset-method}
\alias{.getSubsets,TxSubset-method}
\alias{.validTx,TxSubset-method}
\title{Methods Available for Objects of Class \code{TxSubset}}
\usage{
\S4method{.convertFromBinary}{TxSubset}(txObj, ..., txVec)

\S4method{.convertToBinary}{TxSubset}(txObj, ...)

\S4method{.getPtsSubset}{TxSubset}(object)

\S4method{.getSingleton}{TxSubset}(object)

\S4method{.getSubsetRule}{TxSubset}(object)

\S4method{.getSubsets}{TxSubset}(object)

\S4method{.validTx}{TxSubset}(object, txVec)
}
\description{
Methods Available for Objects of Class \code{TxSubset}

\code{.convertFromBinary(txObj, txVec)}
  converts a -1/1 Tx to user provided tx coding.

\code{.convertToBinary(txObj, data)}
  converts user specified tx variable to binary -1/1.

\code{.getPtsSubset(object)}
 retrieve subset name for which each pt is a member.

\code{.getSingleton(object)}
  retrieve T/F indicator of only 1 tx option available to each pt.

\code{.getSubsetRule(object)}
  retrieve feasible set identification rule.

\code{.getSubsets(object)}
  retrieve subset names and tx options.

\code{.validTx(object, txVec)}
  ensures all elements in txVec are allowed by superset.
}
\keyword{internal}
