% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dynamics.R
\name{get_dynamics}
\alias{get_dynamics}
\title{Calculate hierarchy dynamics}
\usage{
get_dynamics(ranks, type = c("rank", "score"))
}
\arguments{
\item{ranks}{A dataframe such as the output of the ranking functions provided
in the DynaRankR package. Should include at least the following 
columns:
  \describe{
   \item{period}{Study period.}
   \item{id}{Identity of contestant.}
   \item{rank}{Rank of id in period. Only required if calculating
               rank dynamics.}
   \item{score}{Score of id in period. Only required if calculating
               score dynamics.}
  }}

\item{type}{A character string, either 'score' or 'rank'. Determines
whether rank dynamics or score dynamics are calculated.}
}
\value{
Returns the supplied dataframe with new column(s) for hierarchy dynamics. 
        New individuals receive NA for all dynamics because they can not have undergone any changes.
}
\description{
Calculates hierarchy dynamics from an inferred longitudinal hierarchy,
returning the provided longitudinal hierarchy with added columns. 
The function calculates hierarchy dynamics for each individual in each period
(excluding the first period). Dynamics can be calculated in rank units or 
score units by specifying the \strong{type} parameter. Rank dynamics are returned as 
the total dynamics (delta), active dynamics (delta.active), and passive
dynamics (delta.passive). Score dynamics are calculated as delta. 
See Strauss & Holekamp (in revision) for more details.
}
\examples{
female.ranks <- informed_elo(contestants = C.crocuta.female$contestants, convention = 'mri',
initial.ranks = C.crocuta.female$initial.ranks,
interactions = C.crocuta.female$interactions)

female.ranks.score <- get_dynamics(ranks = female.ranks, type = 'score')
female.ranks.rank <- get_dynamics(ranks = female.ranks, type = 'rank')

}
\references{
Strauss ED & Holekamp KE (in revision). Journal of Animal Ecology.
}
