% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MHLS.R
\name{MHLS}
\alias{MHLS}
\title{Metropolis-Hastings lasso sampler under a fixed active set.}
\usage{
MHLS(X, PE, sig2, lbd, weights = rep(1, ncol(X)), B0, S0, A = which(B0 !=
  0), tau = rep(1, ncol(X)), niter = 2000, burnin = 0, PEtype = "coeff",
  updateS.itv = 1, verbose = FALSE, ...)
}
\arguments{
\item{X}{predictor matrix.}

\item{PE, sig2, lbd}{parameters of target distribution.
(point estimate of beta or \code{E(y)} depends on \code{PEtype}, variance estimate of error and lambda).}

\item{weights}{weight vector with length \code{p}(the number of covariates).
Default is \code{weights = rep(1, p)}.}

\item{B0}{numeric vector with length \code{p}.
Initial value of lasso estimator.}

\item{S0}{numeric vector with length \code{p}.
Initial value of subgradients.
If not given, this will be generated in a default way.}

\item{A}{numeric vector. Active coefficient index.
Every active coefficient index in \code{B0} must be included.
Default is \code{A = which(B0 != 0)}.}

\item{tau}{numeric vector with length \code{p}.
Standard deviation of proposal distribution for each coefficient.}

\item{niter}{integer. The number of iterations. Default is \code{niter = 2000}}

\item{burnin}{integer. The length of burin-in periods. Default is \code{burnin = 0}}

\item{PEtype}{Type of \code{PE} which is needed to characterize the target distribution.
Users can choose either \code{"coeff"} or \code{"mu"}.}

\item{updateS.itv}{integer. Update subgradients every \code{updateS.itv} iterations.
Set this value larger than \code{niter} if one wants to skip updating subgradients.}

\item{verbose}{logical. If true, print out the progress step.}

\item{...}{complementary arguments.
\itemize{
 \item{\code{FlipSA :}}{ optional parameter.
This has to be a subset of active set, A. If the index is not listed in FlipSA,
the sign of coefficients which correspond to the listed index will remain fixed.
The default is \code{FlipSA=A}}
 \item{\code{SFindex :}}{ optional parameter. subgradient index for the free coordinate.}
 \item{\code{randomSFindex :}}{ logical. If \code{true}, resample \code{SFindex} every
\code{updateSF.itv} iterations.}
 \item{\code{updateSF.itv :}}{ integer. In every \code{updateSF.itv} iterations,
 randomize \code{SFindex}.}
}}
}
\value{
\code{\link{MHLS}} returns an object of class \code{"MHLS"}.
The functions \code{\link{summary.MHLS}} and \code{\link{plot.MHLS}}
provide a brief summary and generate plots.
\item{beta}{lasso samples.}
\item{subgrad}{subgradient samples.}
\item{acceptHistory}{numbers of acceptance and proposal.}
\item{niter, burnin, PE, type}{same as function arguments.}
}
\description{
Metropolis-Hastings sampler to simulate from the sampling
distribution of lasso given a fixed active set.
}
\details{
Given appropriate initial value, provides Metropolis-Hastings samples
 under the fixed active set. \cr
From the initial values, \code{B0} and {S0}, \code{\link{MHLS}} draws \code{beta} and \code{subgrad} samples.
In every iteration, given \code{t}-th iteration values, \code{t}-th \code{beta} and \code{t}-th \code{subgrad},
a new set of proposed beta and subgradient is sampled. We either accept the proposed sample
and use that as \code{(t+1)}-th iteration values or reuse \code{t}-th iteration values. \cr
See Zhou(2014) for more details.
}
\examples{
#-------------------------
# Low dim
#-------------------------
set.seed(123)
n <- 10
p <- 5
X <- matrix(rnorm(n * p), n)
Y <- X \%*\% rep(1, p) + rnorm(n)
sigma2 <- 1
lbd <- .37
weights <- rep(1, p)
LassoResult <- lassoFit(X = X, Y = Y, lbd = lbd, type = "lasso", weights = weights)
B0 <- LassoResult$B0
S0 <- LassoResult$S0
MHLS(X = X, PE = rep(0, p), sig2 = 1, lbd = 1,
     weights = weights, B0 = B0, S0 = S0, niter = 50, burnin = 0,
     PEtype = "coeff")
MHLS(X = X, PE = rep(0, n), sig2 = 1, lbd = 1,
     weights = weights, B0 = B0, S0 = S0, niter = 50, burnin = 0,
     PEtype = "mu")

#-------------------------
# High dim
#-------------------------
set.seed(123)
n <- 5
p <- 10
X <- matrix(rnorm(n*p),n)
Y <- X \%*\% rep(1,p) + rnorm(n)
weights <- rep(1,p)
LassoResult <- lassoFit(X = X,Y = Y,lbd = lbd, type = "lasso", weights = weights)
B0 <- LassoResult$B0
S0 <- LassoResult$S0
MHLS(X = X, PE = rep(0, p), sig2 = 1, lbd = 1,
     weights = weights, B0 = B0, S0 = S0, niter = 50, burnin = 0,
     PEtype = "coeff")
MHLS(X = X, PE = rep(0, n), sig2 = 1, lbd = 1,
     weights = weights, B0 = B0, S0 = S0, niter = 50, burnin = 0,
     PEtype = "mu")
}
\references{
Zhou, Q. (2014), "Monte Carlo simulation for Lasso-type problems by estimator augmentation,"
Journal of the American Statistical Association, 109, 1495-1516.
}
