% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEffectSize.R
\name{getEffectSize}
\alias{getEffectSize}
\title{Generate effect size from training set}
\usage{
getEffectSize(train, N1, N0)
}
\arguments{
\item{train}{train dataset}

\item{N1}{case number}

\item{N0}{control number}
}
\value{
The effect sizes for each SNP
}
\description{
Only the training set is needed. This function is designed for the condition
that testing data is very large and hard to be loaded into R. The effect size
will be generated directly. Users can calculate scores in plink with the generated
effect size.
}
\details{
The raw training data should be a file with
8 columns including CHROM, POS, A1, A2, OR, P, SNP, N in order.
The CHROM column and the SNP column is used for indexing.
}
\examples{
data("traindat")
 \dontrun{
 getEffectSize(traindat, N1=364, N0=2063)
 }

}
\references{
Song, S., Jiang, W., Hou, L. and Zhao, H. Leveraging effect size distributions to improve polygenic risk scores derived from genome-wide association studies. \emph{Submitted}.
}
\author{
Shuang Song, Wei Jiang, Lin Hou and Hongyu Zhao
}
