% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KSCovL2sup.R
\name{KSCovL2WS}
\alias{KSCovL2WS}
\title{L2-norm test using W-S approximation for equality of several covariance functions}
\usage{
KSCovL2WS(data, apprflag = 0, method = 1, Nsim = 1000)
}
\arguments{
\item{data}{The list variable containing k groups of presmoothed functional observations. 
Each element of the list is a p (number sampling points) by n (sample size) matrix.}

\item{apprflag}{Approximation method, 0: naive method, 1: bias-reduced method.}

\item{method}{placeholder for L2 resampling method, for testing purpose, should not use currently.}

\item{Nsim}{placeholder for L2 resampling method, for testing purpose, should not use currently.}
}
\value{
The p-value of the test.
}
\description{
L2-norm test of equality of several covariance functions, using the 
naive or bias-reduced method (Welch--Satterthwaite approximation)  
to approximate the null distribution.
}
\details{
L2-norm test of equality of several covariance functions. The null distribution will be
approximated by a scaled chi-squared random variable. Two approximation methods are implemented:
naive method and bias-reduced method, which work for Gaussian data only.
The bias-reduced method is more accurate than the naive method for Gaussian data. 
The input functional data should have been registered and presmoothed.
See Ramsay and Silverman (2005) Ch.7 for registration, and Zhang (2013) Ch.3 for presmoothing.
Tools for preprocessing raw functional data are available in R package \pkg{fda}, 
see also Ramsay et al. (2009).
}
\examples{
fdata<-list();
fdata[[1]]<-matrix(rnorm(200),20,10);
fdata[[1]]<-matrix(rnorm(300),20,15);
KSCovL2WS(fdata, 0)
KSCovL2WS(fdata, 1)
}
\references{
ZHANG (2013), GUO et al. (2016), RAMSAY and SILVERMAN (2005), RAMSAY et al. (2009).
}
\seealso{
\code{\link{KSCovL2}}, \code{\link{KSCovsup}}.
}
