% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.CDF}
\alias{plot.CDF}
\title{Plot Comparison Data Forest (CDF) Classification Probability Distribution}
\usage{
\method{plot}{CDF}(x, ...)
}
\arguments{
\item{x}{An object of class \code{CDF}, representing the results to be plotted.}

\item{...}{Additional arguments to be passed to the plotting function.}
}
\value{
None. This function is used for side effects (plotting).
}
\description{
This function generates a bar plot of the classification probabilities predicted by the Comparison Data Forest
for determining the number of factors. The plot displays the probability distribution across different numbers of factors,
with each bar representing the probability for a specific number of factors.
}
\examples{
library(EFAfactors)
set.seed(123)

## Take the data.bfi dataset as an example.
data(data.bfi)

response <- as.matrix(data.bfi[, 1:25]) ## Load data
response <- na.omit(response) ## Remove samples with NA/missing values

## Transform the scores of reverse-scored items to normal scoring
response[, c(1, 9, 10, 11, 12, 22, 25)] <- 6 - response[, c(1, 9, 10, 11, 12, 22, 25)] + 1

\donttest{
CDF.obj <- CDF(response)

## Plot the CDF probabilities
plot(CDF.obj)
}


}
\seealso{
\link[EFAfactors]{CDF}
}
