% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EFAindex.R
\name{EFAindex}
\alias{EFAindex}
\title{Various Indeces in EFA}
\usage{
EFAindex(
  response,
  nfact.max = 10,
  cor.type = "cor",
  use = "pairwise.complete.obs"
)
}
\arguments{
\item{response}{A required \code{N} × \code{I} matrix or data.frame consisting of the responses of \code{N} individuals
to \code{I} items.}

\item{nfact.max}{The maximum number of factors discussed by CD approach. (default = 10)}

\item{cor.type}{How to find the correlations: "cor" is Pearson", "cov" is covariance, "tet" is tetrachoric, "poly" is polychoric,
"mixed" uses mixed cor for a mixture of tetrachorics, polychorics, Pearsons, biserials, and
polyserials, Yuleb is Yulebonett, Yuleq and YuleY are the obvious Yule coefficients as appropriate.}

\item{use}{an optional character string giving a method for computing covariances in the presence of missing values. This
must be one of the strings "everything", "all.obs", "complete.obs", "na.or.complete", or "pairwise.complete.obs" (default).
@seealso \link[stats]{cor}.}
}
\value{
A \code{matrix} with the following components:
\describe{
  \item{CFI}{the Comparative Fit Index}
  \item{RMSEA}{Root Mean Square Error of Approximation (RMSEA) for each number of factors.}
  \item{SRMR}{Standardized Root Mean Square Residual.}
  \item{MAP}{Velicer's MAP values (lower values are better).}
  \item{BIC}{Bayesian Information Criterion (BIC) for each number of factors.}
  \item{SABIC}{Sample-size Adjusted Bayesian Information Criterion (SABIC) for each number of factors.}
  \item{chisq}{Chi-square statistic from the factor analysis output.}
  \item{df}{Degrees of freedom.}
  \item{prob}{Probability that the residual matrix is greater than 0.}
  \item{eChiSq}{Empirically found chi-square statistic.}
  \item{eCRMS}{Empirically found mean residual corrected for degrees of freedom.}
  \item{eBIC}{Empirically found BIC based on the empirically found chi-square statistic.}
  \item{vss}{VSS fit with complexity 1.}
  \item{sqresid}{Squared residual correlations.}
  \item{fit}{Factor fit of the complete model.}
}
}
\description{
A function performs clustering on items by calling \link[psych]{VSS} and \link[psych]{fa}.
Apply the Very Simple Structure (VSS), Comparative Fit Index (CFI), MAP, and other
criteria to determine the appropriate number of factors.
}
\examples{
library(EFAfactors)
set.seed(123)

##Take the data.bfi dataset as an example.
data(data.bfi)

response <- as.matrix(data.bfi[, 1:25]) ## loading data
response <- na.omit(response) ## Remove samples with NA/missing values

## Transform the scores of reverse-scored items to normal scoring
response[, c(1, 9, 10, 11, 12, 22, 25)] <- 6 - response[, c(1, 9, 10, 11, 12, 22, 25)] + 1


## Run EFAindex function with default parameters.
\donttest{
EFAindex.matrix <- EFAindex(response)

print(EFAindex.matrix)

}



}
