% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplot_fs.R
\name{barplot_fs}
\alias{barplot_fs}
\title{Visualization of \code{ensemble_fs} in barplot}
\usage{
barplot_fs(name, efs_table)
}
\arguments{
\item{name}{a character string giving the name of the file.
If it is NULL, then no external file is created
(effectively, no drawing occurs),
but the device may still be queried.}

\item{efs_table}{table object of class matrix (retrieved
from \code{ensemble_fs})}
}
\description{
Generates a barplot from
 the output of \code{\link{ensemble_fs}} and produces
 a pdf-file. This file will be located in the working
 directory. A barplot will only be provided, when the number
 of features does not exceed 100.
 \cr x-axis: sum of all normed importance values of each 
 feature ranging from 0 to 1 
 \cr y-axis: names of features
}
\examples{
 ##loading dataset in Environment
 data(efsdata)
 ##Generate a ranking based on inportance (with default
 ##NA_threshold = 0.7,cor_threshold = 0.2)
 efs<-ensemble_fs(efsdata,5,runs=2)
 ##Create a cumulative barplot based on the output from efs 
 barplot_fs("test",efs)
}
\author{
Ursula Neumann
}
\seealso{
\link{barplot}, \link{pdf}
}

