% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EGA.estimate.R
\name{EGA.estimate}
\alias{EGA.estimate}
\title{A Wrapper Function for \code{EGA}}
\usage{
EGA.estimate(
  data,
  n = NULL,
  model = c("glasso", "TMFG"),
  algorithm = c("walktrap", "louvain"),
  steps = 4,
  cor = c("cor_auto", "pearson", "spearman"),
  ...
)
}
\arguments{
\item{data}{A dataframe with the variables to be used in the analysis or a correlation matrix.
If the data used is a correlation matrix, the argument \code{n} will need to be specified.}

\item{n}{Integer.
Sample size, if the data provided is a correlation matrix}

\item{model}{A string indicating the method to use.
Current options are:

\itemize{

\item{\strong{\code{glasso}}}
{Estimates the Gaussian graphical model using graphical LASSO with
extended Bayesian information criterion to select optimal regularization parameter.
This is the default method}

\item{\strong{\code{TMFG}}}
{Estimates a Triangulated Maximally Filtered Graph}

}}

\item{algorithm}{A string indicating the algorithm to use.
Current options are:

\itemize{

\item{\strong{\code{walktrap}}}
{Computes the Walktrap algorithm using \code{\link[igraph]{cluster_walktrap}}}

\item{\strong{\code{louvain}}}
{Computes the Walktrap algorithm using \code{\link[igraph]{cluster_louvain}}}

}}

\item{steps}{Number of steps to be used in \code{\link[igraph]{cluster_walktrap}} algorithm.
Defaults to 4.}

\item{cor}{Type of correlation matrix to compute. The default uses \code{\link[qgraph]{cor_auto}}.
Current options are:

\itemize{

\item{\strong{\code{cor_auto}}}
{Computes the correlation matrix using the \code{\link[qgraph]{cor_auto}} function from
\code{\link[qgraph]{qgraph}}}.

\item{\strong{\code{pearson}}}
{Computes Pearson's correlation coefficient using the pairwise complete observations via
the \code{\link[stats]{cor}}} function.

\item{\strong{\code{spearman}}}
{Computes Spearman's correlation coefficient using the pairwise complete observations via
the \code{\link[stats]{cor}}} function.
}}

\item{...}{Additional arguments to be passed to \code{\link{EBICglasso.qgraph}}
or \code{\link[NetworkToolbox]{TMFG}}}
}
\value{
Returns a list containing:

\item{estimated.network}{A symmetric network estimated using either the
\code{\link{EBICglasso.qgraph}} or \code{\link[NetworkToolbox]{TMFG}}}

\item{wc}{A vector representing the community (dimension) membership
of each node in the network. \code{NA} values mean that the node
was disconnected from the network}

\item{n.dim}{A scalar of how many total dimensions were identified in the network}

\item{cor.data}{The zero-order correlation matrix}
}
\description{
Estimates the number of dimensions of a given dataset/instrument
using graphical lasso (\code{\link{EBICglasso.qgraph}}) or the
Triangulated Maximally Filtered Graph (\code{\link[NetworkToolbox]{TMFG}})
method and the walktrap community detection algorithm (\code{\link[igraph]{cluster_walktrap}}).
The glasso regularization parameter is set via EBIC.
}
\examples{

\donttest{
#estimate EGA
ega.wmt <- EGA.estimate(data = wmt2[,7:24], model = "glasso")

#estimate EGAtmfg
ega.wmt <- EGA.estimate(data = wmt2[,7:24], model = "TMFG")

#estimate EGA
ega.intel <- EGA.estimate(data = intelligenceBattery[,8:66], model = "glasso")
}
}
\references{
Golino, H. F., & Epskamp, S. (2017).
Exploratory graph analysis: A new approach for estimating the number of dimensions in psychological research.
\emph{PloS one}, \emph{12(6)}, e0174035..
doi: \href{https://doi.org/10.1371/journal.pone.0174035}{journal.pone.0174035}

Golino, H. F., & Demetriou, A. (2017).
Estimating the dimensionality of intelligence like data using Exploratory Graph Analysis.
\emph{Intelligence}, \emph{62}, 54-70.
doi: \href{https://doi.org/10.1016/j.intell.2017.02.007}{j.intell.2017.02.007}

Golino, H., Shi, D., Christensen, A. P., Garrido, L. E., Nieto, M. D., Sadana, R., & Thiyagarajan, J. A. (in press).
Investigating the performance of Exploratory Graph Analysis and traditional techniques to identify the number of latent factors: A simulation and tutorial.
\emph{Psychological Methods}.
doi: \href{https://psyarxiv.com/gzcre/}{10.31234/osf.io/gzcre}
}
\seealso{
\code{\link{bootEGA}} to investigate the stability of EGA's estimation via bootstrap
and \code{\link{CFA}} to verify the fit of the structure suggested by EGA using confirmatory factor analysis.
}
\author{
Alexander P. Christensen <alexpaulchristensen at gmail.com> and Hudson F. Golino <hfg9s at virginia.edu>
}
