% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergoInfo.R
\name{ergoInfo}
\alias{ergoInfo}
\title{Ergodicity Information Index}
\usage{
ergoInfo(data, use = c("edge.list", "weights"))
}
\arguments{
\item{data}{A dynEGA.ind.pop object}

\item{use}{Character.
A string indicating what network element will be used to compute the algorithm complexity, the list of edges or the weights of the network.
Defaults to \code{use = "edge.list"}.
Current options are:

\itemize{

\item{\strong{\code{edge.list}}}
{Calculates the algorithm complexity using the list of edges.}

\item{\strong{\code{weights}}}
{Calculates the algorithm complexity using the weights of the network.}
}}
}
\value{
Returns a list containing:

\item{PrimeWeight}{The prime-weight encoding of the individual networks}

\item{PrimeWeight.pop}{The prime-weight encoding of the population network}

\item{Kcomp}{The Kolmogorov complexity of the prime-weight encoded individual networks}

\item{Kcomp.pop}{The Kolmogorov complexity of the prime-weight encoded population network}

\item{EII}{The Ergodicity Information Index}
}
\description{
Computes the Ergodicity Information Index
}
\author{
Hudson Golino <hfg9s at virginia.edu>
}
