% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tefi.R
\name{tefi}
\alias{tefi}
\title{Total Entropy Fit Index using Von Neumman's entropy (Quantum Information Theory) for correlation matrices}
\usage{
tefi(data, structure)
}
\arguments{
\item{data}{A dataframe or correlation matrix}

\item{structure}{A vector representing the structure (numbers or labels for each item).
Can be theoretical factors or the structure detected by \code{\link{EGA}}}
}
\value{
Returns a list containing:

\item{VN.Entropy.Fit}{The Entropy Fit Index using Von Neumman's entropy}

\item{Total.Correlation}{The total correlation of the dataset}

\item{Average.Entropy}{The average entropy of the dataset}
}
\description{
Computes the fit (TEFI) of a dimensionality structure using Von Neumman's entropy when the input is a correlation matrix.
Lower values suggest better fit of a structure to the data.
}
\examples{
# Load data
wmt <- wmt2[,7:24]

\dontrun{
# Estimate EGA model
ega.wmt <- EGA(data = wmt, model = "glasso")

}

# Compute entropy indices
tefi(data = ega.wmt$correlation, structure = ega.wmt$wc)

}
\references{
Golino, H., Moulder, R. G., Shi, D., Christensen, A. P., Garrido, L. E., Nieto, M. D., Nesselroade, J., Sadana, R., Thiyagarajan, J. A., & Boker, S. M. (2020).
Entropy fit indices: New fit measures for assessing the structure and dimensionality of multiple latent variables.
\emph{Multivariate Behavioral Research}.
}
\seealso{
\code{\link[EGAnet]{EGA}} to estimate the number of dimensions of an instrument using EGA and
\code{\link[EGAnet]{CFA}} to verify the fit of the structure suggested by EGA using confirmatory factor analysis.
}
\author{
Hudson Golino <hfg9s at virginia.edu>, Alexander P. Christensen <alexpaulchristensen@gmail.com>, and Robert Moulder <rgm4fd@virginia.edu>
}
