% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jsd.ergoInfo.R
\name{jsd.ergoInfo}
\alias{jsd.ergoInfo}
\title{Jensen-Shannon Distance Test for Ergodicity}
\usage{
jsd.ergoInfo(
  dynEGA.object,
  method = c("kld", "spectral"),
  threshold = 0.2,
  max.proportion = 0.1
)
}
\arguments{
\item{dynEGA.object}{A \code{\link[EGAnet]{dynEGA}} or a
\code{\link[EGAnet]{dynEGA.ind.pop}} object that is used to match the arguments of the EII object.}

\item{method}{Character.
Method to compute Jensen-Shannon Distance.
Defaults to \code{"spectral"}.
Options:

\itemize{

\item{\code{"kld"}}
{Uses Kullback-Leibler Divergence}

\item{\code{"spectral"}}
{Uses eigenvalues of combinatiorial Laplacian matrix to compute
Von Neumann entropy}

}}

\item{threshold}{Numeric.
Sets the threshold of the \code{\link[EGAnet]{jsd}} determined
to be \strong{too distant} for ergodicity to hold.
Defaults to \code{0.20}.
Values can range between 0 and 1}

\item{max.proportion}{Numeric.
Sets the proportion of \code{\link[EGAnet]{jsd}} values
that are \strong{greater} than the specified \code{threshold}.
Defaults to \code{0.10}.
Values can range between 0 and 1}
}
\value{
Returns a list containing:

\item{boot.ergoInfo}{The values of the Ergodicity Information Index obtained in the bootstrap}

\item{p.value}{The two-sided *p*-value of the bootstrap test for the Ergodicity Information Index.
The null hypothesis is that the empirical Ergodicity Information index is equal to the expected value of the EII
with small variation in the population structure}

\item{effect}{Indicates wheter the empirical EII is greater or less then the bootstrap distribution of EII.}

\item{interpretation}{How you can interpret the result of the test in plain English}

\item{plot.dist}{Histogram of the bootstrapped ergodicity information index}

\item{methods}{Methods to report for print/summary S3methods and automated Methods section}
}
\description{
Tests the Jensen-Shannon Distance (\code{\link[EGAnet]{jsd}}) of each
individual's network structure to the population's network structure. Using a threshold,
the proportion of \code{\link[EGAnet]{jsd}} values \strong{greater} than the threshold
are computed. If this proportion is \strong{greater} or equal to the maximum allowable
proportion of individuals, then the system is determined to be nonergodic. If the
proportion is \strong{fewer} than the maximum allowable proportion, then the system
is determined to be ergodic
}
\examples{
\dontrun{
# Dynamic EGA individual and population structures
dyn1 <- dynEGA.ind.pop(
  data = sim.dynEGA[,-26], n.embed = 5, tau = 1,
  delta = 1, id = 25, use.derivatives = 1,
  model = "glasso", ncores = 2, corr = "pearson"
)

# JSD Ergodicity Test
testing.ergoinfo <- jsd.ergoInfo(
  dynEGA.object = dyn1
)}

}
\references{
Golino, H., Nesselroade, J., & Christensen, A. P. (2022).
Toward a psychology of individuals: The ergodicity information index and a bottom-up approach for finding generalizations.
\emph{PsyArXiv}.
}
\author{
Hudson Golino <hfg9s at virginia.edu> & Alexander P. Christensen <alexander.christensen at Vanderbilt.Edu>
}
