% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riEGA.R
\name{riEGA}
\alias{riEGA}
\title{Random-Intercept \code{\link[EGAnet]{EGA}}}
\usage{
riEGA(
  data,
  n = NULL,
  uni.method = c("expand", "LE", "louvain"),
  corr = c("cor_auto", "pearson", "spearman"),
  model = c("glasso", "TMFG"),
  model.args = list(),
  algorithm = c("walktrap", "louvain"),
  algorithm.args = list(),
  consensus.iter = 100,
  consensus.method = c("highest_modularity", "most_common", "iterative", "lowest_tefi"),
  plot.EGA = TRUE,
  plot.args = list(),
  estimator = c("auto", "WLSMV", "MLR"),
  lavaan.args = list()
)
}
\arguments{
\item{data}{Matrix or data frame.
Variables (down columns) or correlation matrix.
If the input is a correlation matrix,
then argument \code{n} (number of cases) is \strong{required}.
Variables \strong{MUST} be unrecoded -- reversed items should
\strong{remain} reversed}

\item{n}{Integer.
Sample size if \code{data} provided is a correlation matrix}

\item{uni.method}{Character.
What unidimensionality method should be used? 
Defaults to \code{"louvain"}.
Current options are:

\itemize{

\item{\strong{\code{expand}}}
{Expands the correlation matrix with four variables correlated .50.
If number of dimension returns 2 or less in check, then the data 
are unidimensional; otherwise, regular EGA with no matrix
expansion is used. This is the method used in the Golino et al. (2020)
\emph{Psychological Methods} simulation.}

\item{\strong{\code{LE}}}
{Applies the Leading Eigenvalue algorithm (\code{\link[igraph]{cluster_leading_eigen}})
on the empirical correlation matrix. If the number of dimensions is 1,
then the Leading Eigenvalue solution is used; otherwise, regular EGA
is used. This is the final method used in the Christensen, Garrido,
and Golino (2021) simulation.}

\item{\strong{\code{louvain}}}
{Applies the Louvain algorithm (\code{\link[igraph]{cluster_louvain}})
on the empirical correlation matrix using a resolution parameter = 0.95.
If the number of dimensions is 1, then the Louvain solution is used; otherwise,
regular EGA is used. This method was validated in the Christensen (2022) simulation.}

}}

\item{corr}{Type of correlation matrix to compute. The default uses \code{\link[qgraph]{cor_auto}}.
Current options are:

\itemize{

\item{\strong{\code{cor_auto}}}
{Computes the correlation matrix using the \code{\link[qgraph]{cor_auto}} function from
\code{\link[qgraph]{qgraph}}}.

\item{\strong{\code{pearson}}}
{Computes Pearson's correlation coefficient using the pairwise complete observations via
the \code{\link[stats]{cor}}} function.

\item{\strong{\code{spearman}}}
{Computes Spearman's correlation coefficient using the pairwise complete observations via
the \code{\link[stats]{cor}}} function.
}}

\item{model}{Character.
A string indicating the method to use.
Defaults to \code{"glasso"}.
Current options are:

\itemize{

\item{\strong{\code{glasso}}}
{Estimates the Gaussian graphical model using graphical LASSO with
extended Bayesian information criterion to select optimal regularization parameter}

\item{\strong{\code{TMFG}}}
{Estimates a Triangulated Maximally Filtered Graph}

}}

\item{model.args}{List.
A list of additional arguments for \code{\link[EGAnet]{EBICglasso.qgraph}}
or \code{TMFG}}

\item{algorithm}{A string indicating the algorithm to use or a function from \code{\link{igraph}}
Defaults to \code{"walktrap"}.
Current options are:

\itemize{

\item{\strong{\code{walktrap}}}
{Computes the Walktrap algorithm using \code{\link[igraph]{cluster_walktrap}}}

\item{\strong{\code{louvain}}}
{Computes the Louvain algorithm using \code{\link[igraph]{cluster_louvain}}}

}}

\item{algorithm.args}{List.
A list of additional arguments for \code{\link[igraph]{cluster_walktrap}}, \code{\link[igraph]{cluster_louvain}},
or some other community detection algorithm function (see examples)}

\item{consensus.iter}{Numeric.
Number of iterations to perform in consensus clustering for the Louvain algorithm
(see Lancichinetti & Fortunato, 2012).
Defaults to \code{100}}

\item{consensus.method}{Character.
What consensus clustering method should be used? 
Defaults to \code{"highest_modularity"}.
Current options are:

\itemize{

\item{\strong{\code{highest_modularity}}}
{Uses the community solution that achieves the highest modularity
across iterations}

\item{\strong{\code{most_common}}}
{Uses the community solution that is found the most
across iterations}

\item{\strong{\code{iterative}}}
{Identifies the most common community solutions across iterations
and determines how often nodes appear in the same community together.
A threshold of 0.30 is used to set low proportions to zero.
This process repeats iteratively until all nodes have a proportion of
1 in the community solution.
}

\item{\code{lowest_tefi}}
{Uses the community solution that achieves the lowest \code{\link[EGAnet]{tefi}}
across iterations}

}}

\item{plot.EGA}{Boolean.
If \code{TRUE}, returns a plot of the network and its estimated dimensions.
Defaults to \code{TRUE}}

\item{plot.args}{List.
A list of additional arguments for the network plot.
For \code{plot.type = "qgraph"}:

\itemize{

\item{\strong{\code{vsize}}}
{Size of the nodes. Defaults to 6.}

}
For \code{plot.type = "GGally"} (see \code{\link[GGally]{ggnet2}} for
full list of arguments):

\itemize{

\item{\strong{\code{vsize}}}
{Size of the nodes. Defaults to 6.}

\item{\strong{\code{label.size}}}
{Size of the labels. Defaults to 5.}

\item{\strong{\code{alpha}}}
{The level of transparency of the nodes, which might be a single value or a vector of values. Defaults to 0.7.}

\item{\strong{\code{edge.alpha}}}
{The level of transparency of the edges, which might be a single value or a vector of values. Defaults to 0.4.}

 \item{\strong{\code{legend.names}}}
{A vector with names for each dimension}

\item{\strong{\code{color.palette}}}
{The color palette for the nodes. For custom colors,
enter HEX codes for each dimension in a vector.
See \code{\link[EGAnet]{color_palette_EGA}} for
more details and examples}

}}

\item{estimator}{Character.
Estimator to use for random-intercept model (see \href{https://lavaan.ugent.be/tutorial/est.html}{Estimators}
for more details).
Defaults to \code{"auto"}, which selects \code{"MLR"} for continuous data and
\code{"WLSMV"} for mixed and categorical data.
Data are considered continuous data if they have 6 or
more categories (see Rhemtulla, Brosseau-Liard, & Savalei, 2012)}

\item{lavaan.args}{List.
If \code{reduce.method = "latent"}, then \code{\link{lavaan}}'s \code{\link[lavaan]{cfa}}
function will be used to create latent variables to reduce variables.
Arguments should be input as a list. Some example arguments 
(see \code{\link[lavaan]{lavOptions} for full details})}
}
\value{
Returns a list containing:

\item{EGA}{Results from \code{\link[EGAnet]{EGA}}}

\item{RI}{A list containing information about the random-intercept
model (if the model converged):

\itemize{

\item{fit}
{The fit object for the random-intercept model using \code{\link[lavaan]{cfa}}}

\item{lavaan.args}
{The arguments used in \code{\link[lavaan]{cfa}}}

\item{loadings}
{Standardized loadings from the random-intercept model}

\item{correlation}
{Residual correlations after accounting for the random-intercept model}

}

}
}
\description{
Estimates the number of substantive dimensions after controlling for wording effects. 
EGA is applied to a residual correlation matrix after subtracting and random intercept
factor with equal unstandardized loadings from all the regular and unrecoded
reversed items in the database
}
\examples{
# Obtain example data
data <- optimism

\dontrun{# riEGA example
opt.res <- riEGA(data = optimism)}

}
\references{
# Selection of CFA Estimator \cr
Rhemtulla, M., Brosseau-Liard, P. E., & Savalei, V. (2012).
When can categorical variables be treated as continuous? A comparison of robust continuous and categorical SEM estimation methods under suboptimal conditions.
\emph{Psychological Methods}, \emph{17}, 354-373.
}
\author{
Alejandro Garcia-Pardina <alejandrogp97@gmail.com>,
Francisco J. Abad <fjose.abad@uam.es>,
Alexander P. Christensen <alexpaulchristensen@gmail.com>,
Hudson Golino <hfg9s at virginia.edu>,
Luis Eduardo Garrido <luisgarrido@pucmm.edu.do>, and
Robert Moulder <rgm4fd@virginia.edu>
}
