% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensionStability.R
\name{dimensionStability}
\alias{dimensionStability}
\title{Dimension Stability Statistics from \code{\link[EGAnet]{bootEGA}}}
\usage{
dimensionStability(bootega.obj, IS.plot = TRUE, structure = NULL, ...)
}
\arguments{
\item{bootega.obj}{A \code{\link[EGAnet]{bootEGA}} object}

\item{IS.plot}{Boolean (length = 1).
Should the plot be produced for \code{item.replication}?
Defaults to \code{TRUE}}

\item{structure}{Numeric (length = number of variables).
A theoretical or pre-defined structure.
Defaults to \code{NULL} or the empirical \code{\link[EGAnet]{EGA}}
result in the \code{bootega.obj}}

\item{...}{Additional arguments.
Used for deprecated arguments from previous versions of \code{\link[EGAnet]{itemStability}}}
}
\value{
Returns a list containing:

\item{dimension.stability}{A list containing:

\itemize{

\item{\code{structural.consistency} --- }
{The proportion of times that each empirical \code{\link[EGAnet]{EGA}} dimension
\emph{exactly} replicates across the \code{\link[EGAnet]{bootEGA}} samples}

\item{\code{average.item.stability} --- }
{The average item stability in each empirical \code{\link[EGAnet]{EGA}} dimension}

}

}

\item{item.stability}{Results from \code{\link[EGAnet]{itemStability}}}
}
\description{
Based on the \code{\link[EGAnet]{bootEGA}} results, 
this function computes the stability of dimensions. Stability is 
computed by assessing the proportion of times the 
original dimension is exactly replicated in across bootstrap samples
}
\examples{
# Load data
wmt <- wmt2[,7:24]

\dontrun{
# Estimate bootstrap EGA
boot.wmt <- bootEGA(
  data = wmt, iter = 500,
  type = "parametric", ncores = 2
)}

# Estimate stability statistics
dimensionStability(boot.wmt)

}
\references{
\strong{Original implementation of bootEGA} \cr
Christensen, A. P., & Golino, H. (2021).
Estimating the stability of the number of factors via Bootstrap Exploratory Graph Analysis: A tutorial.
\emph{Psych}, \emph{3}(3), 479-500.

\strong{Conceptual introduction} \cr
Christensen, A. P., Golino, H., & Silvia, P. J. (2020).
A psychometric network perspective on the validity and validation of personality trait questionnaires.
\emph{European Journal of Personality}, \emph{34}(6), 1095-1108.
}
\author{
Hudson Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
