% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.nonconvex.R
\name{network.nonconvex}
\alias{network.nonconvex}
\title{GLASSO with Non-convex Penalties}
\usage{
network.nonconvex(
  data,
  n = NULL,
  corr = c("auto", "cor_auto", "cosine", "pearson", "spearman"),
  na.data = c("pairwise", "listwise"),
  penalty = c("iPOT", "LGP", "POP", "SPOT"),
  gamma = NULL,
  lambda = NULL,
  nlambda = 50,
  lambda.min.ratio = 0.01,
  penalize.diagonal = TRUE,
  optimize.over = c("none", "lambda", "both"),
  ic = c("AIC", "AICc", "BIC", "EBIC"),
  ebic.gamma = 0.5,
  fast = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{data}{Matrix or data frame.
Should consist only of variables to be used in the analysis}

\item{n}{Numeric (length = 1).
Sample size \strong{must} be provided if \code{data} provided is a correlation matrix}

\item{corr}{Character (length = 1).
Method to compute correlations.
Defaults to \code{"auto"}.
Available options:

\itemize{

\item \code{"auto"} --- Automatically computes appropriate correlations for
the data using Pearson's for continuous, polychoric for ordinal,
tetrachoric for binary, and polyserial/biserial for ordinal/binary with
continuous. To change the number of categories that are considered
ordinal, use \code{ordinal.categories}
(see \code{\link[EGAnet]{polychoric.matrix}} for more details)

\item \code{"cor_auto"} --- Uses \code{\link[qgraph]{cor_auto}} to compute correlations.
Arguments can be passed along to the function

\item \code{"cosine"} --- Uses \code{\link[EGAnet]{cosine}} to compute cosine similarity

\item \code{"pearson"} --- Pearson's correlation is computed for all
variables regardless of categories

\item \code{"spearman"} --- Spearman's rank-order correlation is computed
for all variables regardless of categories

}

For other similarity measures, compute them first and input them
into \code{data} with the sample size (\code{n})}

\item{na.data}{Character (length = 1).
How should missing data be handled?
Defaults to \code{"pairwise"}.
Available options:

\itemize{

\item \code{"pairwise"} --- Computes correlation for all available cases between
two variables

\item \code{"listwise"} --- Computes correlation for all complete cases in the dataset

}}

\item{penalty}{Character (length = 1).
Available options:

\itemize{

\item \code{"iPOT"} --- Inverse power of two

\item \code{"LGP"} --- Lambda-gamma power

\item \code{"POP"} --- Plus one Pareto

\item \code{"SPOT"} --- Sigmoid power of two (default)

}}

\item{gamma}{Numeric (length = 1).
Adjusts the shape of the penalty.
Defaults:

\itemize{

\item \code{"iPOT"} = 5

\item \code{"LGP"} = 5

\item \code{"POP"} = 4

\item \code{"SPOT"} = 3

}}

\item{lambda}{Numeric (length = 1).
Adjusts the initial penalty provided to the non-convex penalty function}

\item{nlambda}{Numeric (length = 1).
Number of lambda values to test.
Defaults to \code{100}}

\item{lambda.min.ratio}{Numeric (length = 1).
Ratio of lowest lambda value compared to maximal lambda.
Defaults to \code{0.01}}

\item{penalize.diagonal}{Boolean (length = 1).
Should the diagonal be penalized?
Defaults to \code{FALSE}}

\item{optimize.over}{Character (length = 1).
Whether optimization of lambda, gamma, both, or no hyperparamters should be performed.
Defaults to \code{"none"} or no optimization}

\item{ic}{Character (length = 1).
What information criterion should be used for model selection?
Available options include:

\itemize{

\item \code{"AIC"} --- Akaike's information criterion: \eqn{-2L + 2E}

\item \code{"AICc"} --- AIC corrected: \eqn{AIC + \frac{2E^2 + 2E}{n - E - 1}}

\item \code{"BIC"} --- Bayesian information criterion: \eqn{-2L + E \cdot \log{(n)}}

\item \code{"EBIC"} --- Extended BIC: \eqn{BIC + 4E \cdot \gamma \cdot \log{(E)}}

}

Term definitions:

\itemize{

\item \eqn{n} --- sample size

\item \eqn{p} --- number of variables

\item \eqn{E} --- edges

\item \eqn{S} --- empirical correlation matrix

\item \eqn{K} --- estimated inverse covariance matrix (network)

\item \eqn{L = \frac{n}{2} \cdot \log \text{det} K - \sum_{i=1}^p (SK)_{ii}}

}

Defaults to \code{"BIC"}}

\item{ebic.gamma}{Numeric (length = 1)
Value to set gamma parameter in EBIC (see above).
Defaults to \code{0.50}

\emph{Only used if \code{ic = "EBIC"}}}

\item{fast}{Boolean (length = 1).
Whether the \code{\link[glassoFast]{glassoFast}} version should be used
to estimate the GLASSO.
Defaults to \code{TRUE}.

The fast results \emph{may} differ by less than floating point of the original
GLASSO implemented by \code{\link[glasso]{glasso}} and should not impact reproducibility much (set to \code{FALSE} if concerned)}

\item{verbose}{Boolean (length = 1).
Whether messages and (insignificant) warnings should be output.
Defaults to \code{FALSE} (silent calls).
Set to \code{TRUE} to see all messages and warnings for every function call}

\item{...}{Additional arguments to be passed on to \code{\link[EGAnet]{auto.correlate}}}
}
\value{
A network matrix
}
\description{
The graphical least absolute shrinkage and selection operator with
a non-convex regularization penalties
}
\examples{
# Obtain data
wmt <- wmt2[,7:24]

# Obtain network
awe_network <- network.nonconvex(data = wmt)

}
\author{
Alexander P. Christensen <alexpaulchristensen at gmail.com> and
Hudson Golino <hfg9s at virginia.edu>
}
