% Generated by roxygen2 (4.0.2): do not edit by hand
\name{modelEstimation}
\alias{modelEstimation}
\title{Estimation process for the WRTDS (Weighted Regressions on Time, Discharge, and Season)}
\usage{
modelEstimation(eList, windowY = 7, windowQ = 2, windowS = 0.5,
  minNumObs = 100, minNumUncen = 50, edgeAdjust = TRUE)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes}

\item{windowY}{numeric specifying the half-window width in the time dimension, in units of years, default is 7}

\item{windowQ}{numeric specifying the half-window width in the discharge dimension, units are natural log units, default is 2}

\item{windowS}{numeric specifying the half-window with in the seasonal dimension, in units of years, default is 0.5}

\item{minNumObs}{numeric specifying the miniumum number of observations required to run the weighted regression, default is 100}

\item{minNumUncen}{numeric specifying the minimum number of uncensored observations to run the weighted regression, default is 50}

\item{edgeAdjust}{logical specifying whether to use the modified method for calculating the windows at the edge of the record.
The modified method tends to reduce curvature near the start and end of record.  Default is TRUE.}
}
\value{
eList named list with Daily, Sample, and INFO dataframes, along with the surfaces matrix.
Any of these values can be NA, not all EGRET functions will work with missing parts of the named list eList.
}
\description{
This one function does a jack-knife cross-validation of a WRTDS model, fits the surface
(concentration as a function of discharge and time),
estimates daily values of concentration and flux, and flow normalized values.
It returns a named list with the following dataframes: Daily, INFO, Sample, and the matrix: surfaces.
}
\examples{
eList <- Choptank_eList
\dontrun{EGRETreturn <- modelEstimation(eList)
Daily <- EGRETreturn$Daily
Sample <- EGRETreturn$Sample
INFO <- EGRETreturn$INFO
surfaces <- EGRETreturn$surfaces
}
}
\keyword{statistics}
\keyword{water-quality}

