% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFluxTimeDaily.R
\name{plotFluxTimeDaily}
\alias{plotFluxTimeDaily}
\title{Plot of the time series of daily flux estimates and the sample values for the days that were sampled}
\usage{
plotFluxTimeDaily(eList, yearStart = NA, yearEnd = NA, tinyPlot = FALSE,
  fluxUnit = 3, fluxMax = NA, randomCensored = FALSE,
  printTitle = TRUE, plotGenFlux = TRUE, usgsStyle = FALSE, cex = 0.8,
  cex.axis = 1.1, cex.main = 1.1, customPar = FALSE, col = "black",
  lwd = 1, prettyDate = TRUE, ...)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes}

\item{yearStart}{numeric specifying the starting date (expressed as decimal years, for example 1989.0) for the plot}

\item{yearEnd}{numeric specifying the ending date for the plot}

\item{tinyPlot}{logical variable, if TRUE plot is designed to be short and wide, default is FALSE.}

\item{fluxUnit}{number representing in pre-defined fluxUnit class array. \code{\link{printFluxUnitCheatSheet}}}

\item{fluxMax}{number specifying the maximum value to be used on the vertical axis, default is NA (which allows it to be set automatically by the data)}

\item{randomCensored}{logical, if TRUE plot a random value for censored data.  Default is FALSE.}

\item{printTitle}{logical variable if TRUE title is printed, if FALSE title is not printed (this is best for a multi-plot figure)}

\item{plotGenFlux}{logical variable. If \code{TRUE}, annual flux points from 
\code{WRTDSKalman} output are plotted, if \code{FALSE} WRTDS flux is plotted.}

\item{usgsStyle}{logical option to use USGS style guidelines. Setting this option
to TRUE does NOT guarantee USGS compliance. It will only change automatically
generated labels.}

\item{cex}{numerical value giving the amount by which plotting symbols should be magnified}

\item{cex.axis}{magnification to be used for axis annotation relative to the current setting of cex}

\item{cex.main}{magnification to be used for main titles relative to the current setting of cex}

\item{customPar}{logical defaults to FALSE. If TRUE, par() should be set by user before calling this function 
(for example, adjusting margins with par(mar=c(5,5,5,5))). If customPar FALSE, EGRET chooses the best margins depending on tinyPlot.}

\item{col}{color of points on plot, see ?par 'Color Specification'}

\item{lwd}{number line width}

\item{prettyDate}{logical use 'pretty' limits for date axis if TRUE, or force the yearStart/yearEnd as limits if FALSE}

\item{\dots}{arbitrary graphical parameters that will be passed to genericEGRETDotPlot function (see ?par for options)}
}
\description{
This plot is useful for visual examination of the ability of the WRTDS, or other model, to fit the 
data, as seen in a time-series perspective. 

Although there are a lot of optional arguments to this function, most are set to a logical default.

Data come from named list, which contains a Sample dataframe with the sample data, 
a Daily dataframe with the daily flow data,
and an INFO dataframe with metadata.
}
\examples{
eList <- Choptank_eList
# Water year:
plotFluxTimeDaily(eList)
plotFluxTimeDaily(eList, 2001,2009)
}
\seealso{
\code{\link{selectDays}}, \code{\link{genericEGRETDotPlot}}
}
\keyword{graphics}
\keyword{statistics}
\keyword{water-quality}
