% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateMonthlyResults.R
\name{calculateMonthlyResults}
\alias{calculateMonthlyResults}
\title{Calculates monthly mean values of Q, Conc, Flux, FNConc, and FNFlux for the entire record.}
\usage{
calculateMonthlyResults(eList)
}
\arguments{
\item{eList}{named list with at least the Daily dataframes}
}
\value{
MonthlyResults data frame of numeric values describing the monthly average values
}
\description{
Computes the monthly mean values of discharge, concentration, flux, flow-normalized concentration and flow-normalized flux (Q, Conc, Flux, FNConc, and FNFlux) in SI units 
Note that the Flux and FNFlux values are average flux values (not totals). For discharge they are in m3/s, concentration is mg/L, and flux is kg/day.
It returns a data frame containing month, year, decimal year, and mean values of DecYear, Q, Conc, Flux, FNConc, and FNFlux.
}
\examples{
eList <- Choptank_eList
monthlyResults <- calculateMonthlyResults(eList)
}
\keyword{statistics}
\keyword{water-quality}
