% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELISAplate.R
\name{elisa_batch}
\alias{elisa_batch}
\title{Constructor function to build an elisa_batch object}
\usage{
elisa_batch(batchID = NA_character_, desc = NA_character_,
  runs = list(), model.fit = list(), model.name = NA_character_,
  pars = c(-1), num.runs = 1, range.ODs = c(-1, -1),
  normFactor = NaN)
}
\arguments{
\item{batchID}{character string to specify a batches}

\item{desc}{character string for the data/experiment information}

\item{runs}{list of elisa_plates in this run. There could be one or many plates in a run.}

\item{model.fit}{list intend to contain information for the 
fitting of nls.lm. But not using it now.}

\item{model.name}{character string of either the 5pl (5-parameter) or 4pl 
(4-parameter) logistic function}

\item{pars}{numeric the actually parameters for the fitting.
for example for the 5pl model they are c(a, d,xmid, scal, g).}

\item{num.runs}{numeric the number of plates in this run.}

\item{range.ODs}{numeric the min and max ODs}

\item{normFactor}{numeric the batch effect normalization factor ("S").}
}
\value{
an elisa_batch object
}
\description{
S3 method as a constructor to build the S4 
class object of elisa_batch \code{\link{elisa_batch-class}}
}
\details{
S3 method as a constructor to build the S4 
class object of elisa_batch \code{\link{elisa_batch-class}}. 
Normally this is called to build a empty object 
with default values and then load the elisa_run data into it
}
\examples{
elisa_batch();
}
\seealso{
\code{\link{nls.lm}} \code{\link{elisa_run-class}} \code{\link{elisa_plate-class}} 
\code{\link{elisa_batch-class}}
}
