% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting.R
\name{run_emc}
\alias{run_emc}
\title{Custom function for more controlled model estimation}
\usage{
run_emc(
  emc,
  stage,
  stop_criteria,
  p_accept = 0.8,
  step_size = 100,
  verbose = FALSE,
  verboseProgress = FALSE,
  fileName = NULL,
  particles = NULL,
  particle_factor = 50,
  cores_per_chain = 1,
  cores_for_chains = length(emc),
  max_tries = 20,
  n_blocks = 1
)
}
\arguments{
\item{emc}{An emc object}

\item{stage}{A string. Indicates which stage is to be run, either \code{preburn}, \code{burn}, \code{adapt} or \code{sample}}

\item{stop_criteria}{A list. Defines the stopping criteria and for which types of parameters these should hold. See \code{?fit}.}

\item{p_accept}{A double. The target acceptance probability of the MCMC process.
This fine-tunes the width of the search space to obtain the desired acceptance probability. Defaults to .8}

\item{step_size}{An integer. After each step, the stopping requirements as
specified by \code{stop_criteria} are checked and proposal distributions are updated. Defaults to 100.}

\item{verbose}{Logical. Whether to print messages between each step with the current status regarding the stop_criteria.}

\item{verboseProgress}{Logical. Whether to print a progress bar within each step or not. Will print one progress bar for each chain and only if cores_for_chains = 1.}

\item{fileName}{A string. If specified will autosave emc at this location on every iteration.}

\item{particles}{An integer. How many particles to use, default is \code{NULL} and \code{particle_factor} is used instead.
If specified will override \code{particle_factor}.}

\item{particle_factor}{An integer. \code{particle_factor} multiplied by the square root of the number of sampled parameters determines the number of particles used.}

\item{cores_per_chain}{An integer. How many cores to use per chain.
Parallelizes across participant calculations. Only available on Linux or Mac OS.
For Windows, only parallelization across chains (\code{cores_for_chains}) is available.}

\item{cores_for_chains}{An integer. How many cores to use across chains.
Defaults to the number of chains. the total number of cores used is equal to \code{cores_per_chain} * \code{cores_for_chains}.}

\item{max_tries}{An integer. How many times should it try to meet the finish
conditions as specified by stop_criteria? Defaults to 20. max_tries is ignored if the required number of iterations has not been reached yet.}

\item{n_blocks}{An integer. Number of blocks. Will block the parameter chains such that they are updated in blocks. This can be helpful in extremely tough models with a large number of parameters.}
}
\value{
An emc object
}
\description{
Although typically users will rely on \code{fit}, this function can be used for more fine-tuned specification of estimation needs.
The function will throw an error if a stage is skipped,
the stages have to be run in order ("preburn", "burn", "adapt", "sample").
More details can be found in the \code{fit} help files (\code{?fit}).
}
\examples{
\dontrun{
# First define a design
design_DDMaE <- design(data = forstmann,model=DDM,
                           formula =list(v~0+S,a~E, t0~1, s~1, Z~1, sv~1, SZ~1),
                           constants=c(s=log(1)))
# Then make the emc, we've omitted a prior here for brevity so default priors will be used.
emc <- make_emc(forstmann, design)

# Now for example we can specify that we only want to run the "preburn" phase
# for MCMC 200 iterations
emc <- run_emc(emc, stage = "preburn", stop_criteria = list(iter = 200))
}
}
