% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{profile_plot}
\alias{profile_plot}
\title{Likelihood Profile Plots}
\usage{
profile_plot(
  data,
  design,
  p_vector,
  range = 0.5,
  layout = NA,
  p_min = NULL,
  p_max = NULL,
  use_par = NULL,
  n_point = 100,
  n_cores = 1,
  round = 3,
  true_args = list(),
  ...
)
}
\arguments{
\item{data}{A dataframe. Experimental data used, needed for the design mapping}

\item{design}{A design list. Created using \code{design}.}

\item{p_vector}{Named vector of parameter values (typically created with \code{sampled_pars(design)})}

\item{range}{Numeric. The max and min will be p_vector + range/2 and p_vector - range/2, unless specified in p_min or p_max.}

\item{layout}{A vector indicating which layout to use as in par(mfrow = layout). If NA, will automatically generate an appropriate layout.}

\item{p_min}{Named vector. If specified will instead use these values for minimum range of the selected parameters.}

\item{p_max}{Named vector. If specified will instead use these values for maximum range of the selected parameters.}

\item{use_par}{Character vector. If specified will only plot the profiles for the specified parameters.}

\item{n_point}{Integer. Number of evenly spaced points at which to calculate likelihood}

\item{n_cores}{Number of likelihood points evenly spaced between the minimum and maximum likelihood range.}

\item{round}{Integer. To how many digits will the output be rounded.}

\item{true_args}{A list. Optional additional arguments that can be passed to plot.default for the plotting of the true vertical line.}

\item{...}{Optional additional arguments that can be passed to plot.default.}
}
\value{
Vector with highest likelihood point, input and mismatch between true and highest point
}
\description{
Creates likelihood profile plots from a design and the experimental data by
varying one model parameter while holding all others constant.
}
\examples{
\donttest{
# First create a design
design_DDMaE <- design(data = forstmann,model=DDM,
                      formula =list(v~0+S,a~E, t0~1, s~1, Z~1, sv~1, SZ~1),
                      constants=c(s=log(1)))
# Then create a p_vector:
p_vector=c(v_Sleft=-2,v_Sright=2,a=log(.95),a_Eneutral=log(1.5),a_Eaccuracy=log(2),
          t0=log(.25),Z=qnorm(.5),sv=log(.5),SZ=qnorm(.5))
# Make a profile plot for some parameters. Specifying a custom range for t0.
profile_plot(p_vector = p_vector, p_min = c(t0 = -1.35),
             p_max = c(t0 = -1.45), use_par = c("a", "t0", "SZ"),
             data = forstmann, design = design_DDMaE, n_point = 10)
}
}
