% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_coverage.R
\name{set_taxonomicCoverage}
\alias{set_taxonomicCoverage}
\title{set_taxonomicCoverage}
\usage{
set_taxonomicCoverage(sci_names)
}
\arguments{
\item{sci_names}{string (space seperated) or list or data frame of scientific names for species covered.}
}
\value{
a taxonomicCoverage object for EML
}
\description{
set_taxonomicCoverage
}
\details{
Turn a data.frame or a list of scientific names into a taxonomicCoverage block
sci_names can be a space-separated character string or a data frame with column names as rank name
or a list of user-defined taxonomicClassification
}
\note{
If "sci_names" is a data frame, column names of the data frame are rank names.
For user-defined "sci_names", users must make sure that the order of rank names
they specify is from high to low.
Ex. "Kingdom","Phylum","Class","Order","Family","Genus","Species","Common"
}
\examples{
taxon_coverage <-
 set_taxonomicCoverage(list(KINGDOM="Plantae",
                            PHYLUM="Phaeophyta",
                            CLASS="Phaeophyceae",
                            ORDER="Laminariales",
                            FAMILY="Lessoniaceae",
                            GENUS="Macrocystis",
                            genusSpecies="Macrocystis pyrifera",
                            commonName="MAPY"))

df <- data.frame(KINGDOM="Plantae",
                 PHYLUM="Phaeophyta",
                 CLASS="Phaeophyceae",
                 ORDER="Laminariales",
                 FAMILY="Lessoniaceae",
                 GENUS="Macrocystis",
                 genusSpecies="Macrocystis pyrifera",
                 commonName="MAPY")
taxon_coverage <- set_taxonomicCoverage(df)

}

