% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.points.R
\name{sim.points}
\alias{sim.points}
\title{Simulate a point process from an enmtools.model object}
\usage{
sim.points(
  object,
  n.points = 1000,
  seed = NA,
  sample.type = "ppp",
  replace = FALSE,
  threshold = NA,
  ...
)
}
\arguments{
\item{object}{entools.model object to simulate from}

\item{n.points}{approximate number of points to simulate. You may get small number fewer or greater.  If you need an exact number of points, generate too many, then drop the extra ones.}

\item{seed}{optional seed for the random number generator}

\item{sample.type}{method for sampling occurrence points.  Default is "ppp", which is a poisson point process.  Also accepts "binomial" for treating suitabilities as binomial trials, "thresh.pa" for sampling with equal probability every grid cell above a certain threshold value, and "thresh.con" for sampling in proportion to suitability above a certain threshold value.}

\item{replace}{whether to sample with replacement.}

\item{threshold}{a threshold suitability below which probability of sampling drops to zero.  Used for "thresh.pa" and "thresh.con" sampling.}

\item{...}{additional parameters, not currently used but included for S3 compatability}
}
\value{
A data frame of simulated points from the enmtools.model object
}
\description{
Function that takes an \code{enmtools.model} object and simulates points
from it using a point process.
}
