% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PopulationClass.R
\name{initialize,Population-method}
\alias{initialize,Population-method}
\title{Initialize method for the \code{Population} class}
\usage{
\S4method{initialize}{Population}(
  .Object,
  name,
  size,
  dioecy,
  selfRate,
  demography,
  growthRate,
  initGenoFreq,
  genomeObj,
  initPopSize,
  selectionObj,
  mutMatrixObj
)
}
\arguments{
\item{.Object}{a \code{Population} object}

\item{name}{the name of the population.}

\item{size}{the size of the population.}

\item{dioecy}{logical indicating whether the population is dioecious or not
(hermaphrodite).}

\item{selfRate}{the selfing rate of the population}

\item{demography}{logical indicating whether the population has stochastic
demography (this does not include migration), i.e. non-constant size and
potentially population growth or decay, depending on the situation it is in.}

\item{growthRate}{growth rate of the population.}

\item{initGenoFreq}{A row matrix of the size of the genotype number
describing the initial allele frequencies common to all simulations}

\item{genomeObj}{a \code{Genome} object}

\item{initPopSize}{initial population size, knowing that if the demography
is extinct, the initial population size will automatically be set equal to
the population size.}

\item{selectionObj}{a \code{Selection} object}

\item{mutMatrixObj}{a \code{MutationMatrix} object}
}
\value{
a \code{Population} object
}
\description{
Initialize method for the \code{Population} class
}
\author{
Ehouarn Le Faou
}
