% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.cormantel.R
\name{eco.cormantel}
\alias{eco.cormantel}
\title{Mantel correlogram}
\usage{
eco.cormantel(z, xy, int, smax, nsim = 99, latlon = FALSE,
  adjust = c("none", "holm", "hochberg", "hommel", "bonferroni", "BH", "BY",
  "fdr"), alternative = c("auto", "two.sided", "greater", "less"),
  test = c("permutation", "bootstrap"), ...)
}
\arguments{
\item{z}{Vector for the analysis.}

\item{xy}{Data frame or matrix with UTM or decimal coordinates.}

\item{int}{Interval distance in m.}

\item{smax}{Maximum distance in m.}

\item{nsim}{Number of Monte-Carlo simulations.}

\item{latlon}{Are the coordinates in decimal degrees format? Default FALSE.}

\item{adjust}{Correction method passed to \code{\link[stats]{p.adjust}}.
Default is "fdr".}

\item{alternative}{The alternative hypothesis. If "auto" is selected (default) the
program determines the hypothesis by difference between the median of the simulations
and the observed value. Other options are: "two.sided", "greater" and "less".}

\item{test}{If test = "bootstrap", the program generates a bootstrap
resampling and the associated confidence intervals of the null hypothesis.
 If test = "permutation" (default) a permutation test is made and the p value
 is calculated.}

\item{...}{Additional arguments passed to \code{\link[stats]{dist}}.}
}
\description{
This program computes the Mantel correlogram for the data z,
with p values or a confidence interval for the null hypothesis.
If the coordinates are given in decimal degrees, set latlon = TRUE.
In that case, a distance matrix is computed under a spherical Earth model.
A distance matrix with UTM coordinates is suggested as imput.
}
\examples{
\dontrun{
data(eco.test)
corm <- eco.cormantel(z = eco$P, xy = eco$XY,
nsim = 99,int=50, smax=1000, test = "permutation")
plot(corm)
corm <- eco.cormantel(z = eco$P, xy = eco$XY,
nsim = 99,int=50, smax=1000, test = "bootstrap")
plot(corm)
}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

